/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.ux.application.validation.ValidationMessage;
import org.teamapps.ux.component.field.FieldMessage;

public class ValidationResult {
    private boolean success;
    private List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();

    public static ValidationResult success() {
        return new ValidationResult(true);
    }

    public static ValidationResult failure(ValidationMessage message) {
        return new ValidationResult(false).addMessage(message);
    }

    public ValidationResult() {
    }

    public ValidationResult(boolean success) {
        this.success = success;
    }

    public ValidationResult addMessage(ValidationMessage message) {
        this.validationMessages.add(message);
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<ValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setValidationMessages(List<ValidationMessage> validationMessages) {
        this.validationMessages = validationMessages;
    }

    public Map<String, List<FieldMessage>> getFieldMessagesMap() {
        return this.validationMessages.stream().collect(Collectors.groupingBy(message -> message.getPropertyName(), Collectors.mapping(message -> message.getFieldMessage(), Collectors.toList())));
    }
}

