/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiLabel;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;

public class Label
extends AbstractField<String> {
    public final Event<Void> onClicked = new Event();
    private String caption;
    private Icon icon;
    private AbstractField<?> targetField;

    public Label(String caption) {
        this.caption = caption;
    }

    public Label(String caption, Icon icon) {
        this(caption);
        this.icon = icon;
    }

    public UiField createUiComponent() {
        UiLabel uiLabel = new UiLabel(this.caption);
        this.mapAbstractFieldAttributesToUiField((UiField)uiLabel);
        uiLabel.setIcon(this.getSessionContext().resolveIcon(this.icon));
        uiLabel.setTargetField(this.targetField != null ? this.targetField.createUiComponentReference() : null);
        return uiLabel;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_LABEL_CLICKED: {
                this.onClicked.fire(null);
            }
        }
    }

    @Override
    protected void doDestroy() {
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.queueCommandIfRendered(() -> new UiLabel.SetCaptionCommand(this.getId(), caption));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.queueCommandIfRendered(() -> new UiLabel.SetIconCommand(this.getId(), this.getSessionContext().resolveIcon(icon)));
    }

    public AbstractField<?> getTargetField() {
        return this.targetField;
    }

    public Label setTargetField(AbstractField<?> targetField) {
        if (targetField == this) {
            throw new IllegalArgumentException("Labels may not reference themselves!");
        }
        this.targetField = targetField;
        this.queueCommandIfRendered(() -> new UiLabel.SetTargetFieldCommand(this.getId(), targetField.createUiComponentReference()));
        return this;
    }
}

