/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.combobox;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComboBox;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.combobox.AbstractComboBox;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.BaseTreeModel;

public class ComboBox<RECORD>
extends AbstractComboBox<ComboBox, RECORD, RECORD>
implements TextInputHandlingField {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComboBox.class);
    public final Event<String> onFreeTextEntered = new Event();
    private String freeTextEntry;

    public ComboBox(BaseTreeModel<RECORD> model) {
        super(model);
    }

    public ComboBox(List<RECORD> staticData) {
        super(staticData);
    }

    public ComboBox() {
        super((List)null);
    }

    public ComboBox(Template template) {
        super((List)null);
        this.setTemplate(template);
    }

    public static <ENUM extends Enum> ComboBox<ENUM> createForEnum(Class<ENUM> enumClass) {
        return new ComboBox<Enum>(Arrays.asList((Enum[])enumClass.getEnumConstants()));
    }

    public UiField createUiComponent() {
        UiComboBox comboBox = new UiComboBox();
        this.mapCommonUiComboBoxProperties(comboBox);
        return comboBox;
    }

    @Override
    public void setValue(RECORD record) {
        super.setValue(record);
        this.freeTextEntry = null;
    }

    @Override
    public RECORD convertUiValueToUxValue(Object value) {
        this.freeTextEntry = null;
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            this.freeTextEntry = null;
            Object record = this.recordCache.getRecordByClientId((Integer)value);
            return record;
        }
        if (value instanceof String) {
            String freeText = (String)value;
            if (this.freeTextRecordFactory != null) {
                Object record = this.freeTextRecordFactory.apply(freeText);
                this.recordCache.replaceRecords(Collections.singletonList(record)).commit();
            } else {
                this.freeTextEntry = freeText;
            }
            this.onFreeTextEntered.fire(freeText);
            return null;
        }
        throw new IllegalArgumentException("Unknown ui value type: " + value);
    }

    @Override
    public Object convertUxValueToUiValue(RECORD record) {
        if (record == null) {
            return null;
        }
        this.recordCache.addRecord(record).commit();
        return this.createUiTreeRecordWithoutParentRelation(record);
    }

    public String getFreeText() {
        return this.freeTextEntry;
    }
}

