/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.dto.UiMediaTrackData;
import org.teamapps.dto.UiMediaTrackMarker;
import org.teamapps.ux.component.media.TrackMarkerData;

public class MediaTrackData {
    private int trackCount;
    private List<TrackMarkerData> markerData = new ArrayList<TrackMarkerData>();
    private List<TrackData> data = new ArrayList<TrackData>();

    public List<UiMediaTrackMarker> getMarkers() {
        ArrayList<UiMediaTrackMarker> markers = new ArrayList<UiMediaTrackMarker>();
        for (TrackMarkerData marker : this.markerData) {
            markers.add(marker.createMarker());
        }
        return markers;
    }

    public List<UiMediaTrackData> getTrackData() {
        ArrayList<UiMediaTrackData> result = new ArrayList<UiMediaTrackData>();
        for (TrackData trackData : this.data) {
            UiMediaTrackData td = new UiMediaTrackData();
            td.setTime(trackData.getTime());
            td.setValues(trackData.getValues());
            result.add(td);
        }
        return result;
    }

    public void addMarker(TrackMarkerData marker) {
        this.markerData.add(marker);
    }

    public void addData(long time, int[] values) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int value : values) {
            list.add(value);
        }
        this.data.add(new TrackData(time, list));
    }

    private void addData(long time, List<Integer> values) {
        this.data.add(new TrackData(time, values));
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public void setTrackCount(int trackCount) {
        this.trackCount = trackCount;
    }

    public List<TrackMarkerData> getMarkerData() {
        return this.markerData;
    }

    public void setMarkerData(List<TrackMarkerData> markerData) {
        this.markerData = markerData;
    }

    public List<TrackData> getData() {
        return this.data;
    }

    public void setData(List<TrackData> data) {
        this.data = data;
    }

    class TrackData {
        private long time;
        private List<Integer> values;

        public TrackData(long time, List<Integer> values) {
            this.time = time;
            this.values = values;
        }

        public long getTime() {
            return this.time;
        }

        public List<Integer> getValues() {
            return this.values;
        }
    }
}

