/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teamapps.data.value.Sorting;
import org.teamapps.ux.component.table.AbstractTableModel;

public class ListTableModel<RECORD>
extends AbstractTableModel<RECORD> {
    private List<RECORD> list = new ArrayList<RECORD>();
    private Predicate<RECORD> filter = record -> true;

    public ListTableModel() {
    }

    public ListTableModel(List<RECORD> list) {
        this.list.addAll(list);
    }

    public void setList(List<RECORD> list) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.list = new ArrayList<RECORD>(list);
        this.onAllDataChanged.fire(null);
    }

    public void addRecord(RECORD record) {
        this.list.add(record);
        this.onRecordAdded.fire(record);
    }

    public void addRecords(List<RECORD> records) {
        this.list.addAll(records);
        this.onAllDataChanged.fire(null);
    }

    @Override
    public int getCount() {
        if (this.filter == null) {
            return this.list.size();
        }
        return (int)this.list.stream().filter(this.filter).count();
    }

    @Override
    public List<RECORD> getRecords(int startIndex, int length, Sorting sorting) {
        if (this.filter == null) {
            return this.list.subList(startIndex, Math.min(this.list.size(), startIndex + length));
        }
        return this.list.stream().filter(this.filter).skip(startIndex).limit(length).collect(Collectors.toList());
    }

    public List<RECORD> getAllRecords() {
        return new ArrayList<RECORD>(this.list);
    }

    @Override
    public List<RECORD> getChildRecords(RECORD parentRecord, Sorting sorting) {
        return null;
    }

    public Predicate<RECORD> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<RECORD> filter) {
        this.filter = filter;
        this.onAllDataChanged.fire(null);
    }
}

