/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.toolbar;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.AbstractUiToolContainer;
import org.teamapps.dto.UiToolbarButton;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ToolbarButton {
    public final Event<AbstractUiToolContainer.ToolbarButtonClickEvent> onClick = new Event();
    public final Event<AbstractUiToolContainer.ToolbarDropDownItemClickEvent> onDropDownItemClick = new Event();
    private ToolbarButtonGroup toolbarButtonGroup;
    private String clientId = UUID.randomUUID().toString();
    private final Object record;
    private Template template;
    private PropertyExtractor propertyExtractor;
    private String openNewTabWithUrl;
    private Component togglesFullScreenOnComponent;
    private Supplier<Component> dropDownComponentSupplier;
    private boolean eagerDropDownRendering = false;
    private int droDownPanelWidth;
    private boolean visible = true;
    private Color backgroundColor;
    private Color hoverBackgroundColor;

    public ToolbarButton(Object record) {
        this(null, record, null, null, null, 0);
    }

    public ToolbarButton(Template template, Object record) {
        this(template, record, null, null, null, 0);
    }

    public ToolbarButton(Template template, Object record, Component dropDownView) {
        this(template, record, null, null, dropDownView, 0);
    }

    private ToolbarButton(Template template, Object record, String openNewTabWithUrl, Component togglesFullScreenOnComponent, Component dropDownView, int droDownPanelWidth) {
        this.template = template;
        this.record = record;
        this.openNewTabWithUrl = openNewTabWithUrl;
        this.togglesFullScreenOnComponent = togglesFullScreenOnComponent;
        if (dropDownView != null) {
            this.dropDownComponentSupplier = () -> dropDownView;
        }
        this.droDownPanelWidth = droDownPanelWidth;
    }

    public static ToolbarButton create(Icon icon, String caption, String description) {
        return new ToolbarButton(null, new BaseTemplateRecord(icon, caption, description));
    }

    public static ToolbarButton createLarge(Icon icon, String caption, String description) {
        return new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord(icon, caption, description));
    }

    public static ToolbarButton createLargeDarkTheme(Icon icon, String caption, String description) {
        return new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON.createDarkThemeTemplate(), new BaseTemplateRecord(icon, caption, description));
    }

    public static ToolbarButton createSmall(Icon icon, String caption) {
        return ToolbarButton.createSmall(icon, caption, null);
    }

    public static ToolbarButton createSmall(Icon icon, String caption, String description) {
        return new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_SMALL, new BaseTemplateRecord(icon, caption, description));
    }

    public static ToolbarButton createSmallDarkTheme(Icon icon, String caption, String description) {
        return new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_SMALL.createDarkThemeTemplate(), new BaseTemplateRecord(icon, caption, description));
    }

    public static ToolbarButton createTiny(Icon icon, String caption) {
        return new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord(icon, caption));
    }

    public static ToolbarButton createOpenNewTabButton(Template template, BaseTemplateRecord Object2, String newTabUrl) {
        return new ToolbarButton(template, Object2, newTabUrl, null, null, 0);
    }

    public static ToolbarButton createFullScreenToggleButton(BaseTemplateRecord Object2, Component togglesFullScreenOnComponent) {
        return new ToolbarButton(null, Object2, null, togglesFullScreenOnComponent, null, 0);
    }

    public static ToolbarButton createFullScreenToggleButton(Template template, BaseTemplateRecord Object2, Component togglesFullScreenOnComponent) {
        return new ToolbarButton(template, Object2, null, togglesFullScreenOnComponent, null, 0);
    }

    public UiToolbarButton createUiToolbarButton() {
        Template template = this.getAppliedTemplate();
        Map<String, Object> values = this.getAppliedPropertyExtractor().getValues(this.record, template.getDataKeys());
        UiToolbarButton ui = new UiToolbarButton(this.clientId, template.createUiTemplate(), values);
        if (this.eagerDropDownRendering && this.dropDownComponentSupplier != null) {
            ui.setDropDownComponent(this.dropDownComponentSupplier.get().createUiComponentReference());
        }
        ui.setHasDropDown(this.dropDownComponentSupplier != null);
        ui.setDropDownPanelWidth(this.droDownPanelWidth > 0 ? this.droDownPanelWidth : 450);
        ui.setVisible(this.visible);
        ui.setOpenNewTabWithUrl(this.openNewTabWithUrl);
        ui.setTogglesFullScreenOnComponent(this.togglesFullScreenOnComponent != null ? this.togglesFullScreenOnComponent.getId() : null);
        ui.setBackgroundColor(UiUtil.createUiColor(this.backgroundColor));
        ui.setHoverBackgroundColor(UiUtil.createUiColor(this.hoverBackgroundColor));
        return ui;
    }

    public ToolbarButton setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        if (oldValue != visible && this.toolbarButtonGroup != null) {
            this.toolbarButtonGroup.handleButtonVisibilityChange(this.clientId, visible);
        }
        return this;
    }

    public ToolbarButton setOpenNewTabWithUrl(String openNewTabWithUrl) {
        this.openNewTabWithUrl = openNewTabWithUrl;
        return this;
    }

    public ToolbarButton setTogglesFullScreenOnComponent(Component togglesFullScreenOnComponent) {
        this.togglesFullScreenOnComponent = togglesFullScreenOnComponent;
        return this;
    }

    String getClientId() {
        return this.clientId;
    }

    public Object getRecord() {
        return this.record;
    }

    public ToolbarButtonGroup getToolbarButtonGroup() {
        return this.toolbarButtonGroup;
    }

    public String getOpenNewTabWithUrl() {
        return this.openNewTabWithUrl;
    }

    public Component getTogglesFullScreenOnComponent() {
        return this.togglesFullScreenOnComponent;
    }

    public int getDroDownPanelWidth() {
        return this.droDownPanelWidth;
    }

    public boolean isDropDownLazyInitializing() {
        return this.dropDownComponentSupplier != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ToolbarButton setToolbarButtonGroup(ToolbarButtonGroup toolbarButtonGroup) {
        this.toolbarButtonGroup = toolbarButtonGroup;
        return this;
    }

    public ToolbarButton setDroDownPanelWidth(int droDownPanelWidth) {
        this.droDownPanelWidth = droDownPanelWidth;
        return this;
    }

    public ToolbarButton setDropDownComponent(Component dropDownComponent) {
        this.dropDownComponentSupplier = () -> dropDownComponent;
        return this;
    }

    public boolean isEagerDropDownRendering() {
        return this.eagerDropDownRendering;
    }

    public ToolbarButton setEagerDropDownRendering(boolean eagerDropDownRendering) {
        this.eagerDropDownRendering = eagerDropDownRendering;
        return this;
    }

    public Template getTemplate() {
        return this.template;
    }

    public ToolbarButton setTemplate(Template template) {
        this.template = template;
        return this;
    }

    public Template getAppliedTemplate() {
        if (this.template != null) {
            return this.template;
        }
        if (this.toolbarButtonGroup != null && this.toolbarButtonGroup.getAppliedTemplate() != null) {
            return this.toolbarButtonGroup.getAppliedTemplate();
        }
        return BaseTemplate.TOOLBAR_BUTTON;
    }

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public ToolbarButton setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
        return this;
    }

    public PropertyExtractor getAppliedPropertyExtractor() {
        return this.propertyExtractor != null ? this.propertyExtractor : this.toolbarButtonGroup.getAppliedPropertyExtractor();
    }

    public Supplier<Component> getDropDownComponentSupplier() {
        return this.dropDownComponentSupplier;
    }

    Component getDropDownComponent() {
        return this.dropDownComponentSupplier != null ? this.dropDownComponentSupplier.get() : null;
    }

    public ToolbarButton setDropDownComponentSupplier(Supplier<Component> dropDownComponentSupplier) {
        this.dropDownComponentSupplier = dropDownComponentSupplier;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ToolbarButton setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (this.toolbarButtonGroup != null) {
            this.toolbarButtonGroup.handleColorChange(this.clientId, backgroundColor, this.hoverBackgroundColor);
        }
        return this;
    }

    public Color getHoverColor() {
        return this.hoverBackgroundColor;
    }

    public ToolbarButton setHoverBackgroundColor(Color hoverBackgroundColor) {
        this.hoverBackgroundColor = hoverBackgroundColor;
        if (this.toolbarButtonGroup != null) {
            this.toolbarButtonGroup.handleColorChange(this.clientId, this.backgroundColor, hoverBackgroundColor);
        }
        return this;
    }
}

