/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.popup.Popup;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.TemplateReference;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionStore;

public interface SessionContext {
    public ClientInfo getClientInfo();

    public long getLastClientEventTimestamp();

    public void setLastClientEventTimestamp(long var1);

    public boolean isOpen();

    public void destroy();

    public Event<Void> onDestroyed();

    public <T> void queueCommand(UiCommand<T> var1);

    public <T> void queueCommand(UiCommand<T> var1, Consumer<T> var2);

    public void flushCommands();

    public IconTheme getIconTheme();

    public void setIconTheme(IconTheme var1);

    default public Locale getLanguageLocale() {
        return this.getConfiguration().getLanguageLocale();
    }

    default public ZoneId getTimeZone() {
        return this.getConfiguration().getTimeZone();
    }

    default public String resolveIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return icon.getQualifiedIconId(this.getIconTheme());
    }

    public Locale getLocale();

    public ResourceBundle getMessageBundle();

    public String getLocalized(String var1, Object ... var2);

    public SessionStore getSessionStore();

    default public void registerComponent(Component component) {
        this.getSessionStore().setSessionValue(component.getId(), component);
    }

    default public void unregisterComponent(Component component) {
        this.getSessionStore().setSessionValue(component.getId(), null);
    }

    default public Component getComponent(String componentId) {
        return (Component)this.getSessionStore().getSessionValue(componentId);
    }

    public String createFileLink(File var1);

    default public String createResourceLink(Supplier<InputStream> inputStreamSupplier, long length) {
        return this.createResourceLink(inputStreamSupplier, length, null);
    }

    default public String createResourceLink(Supplier<InputStream> inputStreamSupplier, long length, String resourceName) {
        return this.createResourceLink(inputStreamSupplier, length, resourceName, null);
    }

    default public String createResourceLink(final Supplier<InputStream> inputStreamSupplier, final long length, final String resourceName, String uniqueIdentifier) {
        return this.createResourceLink(new Resource(){

            @Override
            public InputStream getInputStream() {
                return (InputStream)inputStreamSupplier.get();
            }

            @Override
            public long getLength() {
                return length;
            }

            @Override
            public Date getLastModified() {
                return new Date();
            }

            @Override
            public Date getExpires() {
                return new Date(System.currentTimeMillis() + 600000000L);
            }

            @Override
            public String getName() {
                return resourceName;
            }

            @Override
            public String getMimeType() {
                return null;
            }
        }, uniqueIdentifier);
    }

    default public String createResourceLink(Resource resource) {
        return this.createResourceLink(resource, null);
    }

    public String createResourceLink(Resource var1, String var2);

    public Resource getBinaryResource(int var1);

    public File getUploadedFileByUuid(String var1);

    public TemplateReference registerTemplate(String var1, Template var2);

    public void registerTemplates(Map<String, Template> var1);

    public Template getTemplate(String var1);

    public void runWithContext(Runnable var1);

    default public void showWindow(Window window, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowWindowCommand(window.createUiComponentReference(), animationDuration));
    }

    default public void closeWindow(Window window, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.CloseWindowCommand(window.getId(), animationDuration));
    }

    default public void closeWindow(String windowId, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.CloseWindowCommand(windowId, animationDuration));
    }

    default public void downloadFile(String fileUrl, String downloadFileName) {
        this.queueCommand((UiCommand)new UiRootPanel.DownloadFileCommand(fileUrl, downloadFileName));
    }

    public SessionConfiguration getConfiguration();

    public void setConfiguration(SessionConfiguration var1);

    default public void registerBackgroundImage(String id, String image, String blurredImage) {
        this.queueCommand((UiCommand)new UiRootPanel.RegisterBackgroundImageCommand(id, image, blurredImage));
    }

    default public void setBackgroundImage(String id, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundImageCommand(id, animationDuration));
    }

    default public void setBackgroundColor(Color color, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundColorCommand(UiUtil.createUiColor(color), animationDuration));
    }

    default public void exitFullScreen() {
        this.queueCommand((UiCommand)new UiRootPanel.ExitFullScreenCommand());
    }

    default public void addRootComponent(String containerElementId, RootPanel rootPanel) {
        this.queueCommand((UiCommand)new UiRootPanel.BuildRootPanelCommand(containerElementId, rootPanel.createUiComponentReference()));
    }

    default public void addClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.AddClientTokenCommand(token));
    }

    default public void removeClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.RemoveClientTokenCommand(token));
    }

    default public void clearClientTokens() {
        this.queueCommand((UiCommand)new UiRootPanel.ClearClientTokensCommand());
    }

    default public void showNotification(Notification notification) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowNotificationCommand(notification.createUiNotification()));
    }

    default public void showNotification(Icon icon, String caption) {
        Notification notification = Notification.createWithIconAndCaption(icon, caption);
        notification.setPosition(NotificationPosition.TOP_RIGHT);
        notification.setEntranceAnimation(EntranceAnimation.SLIDE_IN_UP);
        notification.setExitAnimation(ExitAnimation.SLIDE_OUT_UP);
        notification.setDismissable(true);
        notification.setShowProgressBar(false);
        notification.setDisplayTimeInMillis(5000);
        this.showNotification(notification);
    }

    default public void showNotification(Icon icon, String caption, String description, boolean dismissable, int displayTimeInMillis, boolean showProgress) {
        Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
        notification.setPosition(NotificationPosition.TOP_RIGHT);
        notification.setEntranceAnimation(EntranceAnimation.SLIDE_IN_LEFT);
        notification.setExitAnimation(ExitAnimation.FADE_OUT_UP);
        notification.setDismissable(dismissable);
        notification.setDisplayTimeInMillis(displayTimeInMillis);
        notification.setShowProgressBar(showProgress);
        this.showNotification(notification);
    }

    public void showPopupAtCurrentMousePosition(Popup var1);

    public void showPopup(Popup var1);
}

