/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import org.teamapps.dto.UiCalendarViewMode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CalendarViewMode {
    YEAR{

        @Override
        LocalDate getDisplayStart(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return CalendarViewMode.floorToFirstDayOfWeek(LocalDate.of(localDate.getYear(), 1, 1), firstDayOfWeek);
        }

        @Override
        LocalDate getDisplayEnd(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return MONTH.getDisplayEnd(LocalDate.of(localDate.getYear(), 12, 1), firstDayOfWeek);
        }

        @Override
        public LocalDate decrement(LocalDate displayedDate) {
            return displayedDate.minusYears(1L);
        }

        @Override
        public LocalDate increment(LocalDate displayedDate) {
            return displayedDate.plusYears(1L);
        }
    }
    ,
    MONTH{

        @Override
        LocalDate getDisplayStart(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return CalendarViewMode.floorToFirstDayOfWeek(localDate.withDayOfMonth(1), firstDayOfWeek);
        }

        @Override
        LocalDate getDisplayEnd(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return this.getDisplayStart(localDate, firstDayOfWeek).plusDays(42L);
        }

        @Override
        public LocalDate decrement(LocalDate displayedDate) {
            return displayedDate.minusMonths(1L);
        }

        @Override
        public LocalDate increment(LocalDate displayedDate) {
            return displayedDate.plusMonths(1L);
        }
    }
    ,
    WEEK{

        @Override
        LocalDate getDisplayStart(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return CalendarViewMode.floorToFirstDayOfWeek(localDate, firstDayOfWeek);
        }

        @Override
        LocalDate getDisplayEnd(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return this.getDisplayStart(localDate, firstDayOfWeek).plusDays(7L);
        }

        @Override
        public LocalDate decrement(LocalDate displayedDate) {
            return displayedDate.minusDays(7L);
        }

        @Override
        public LocalDate increment(LocalDate displayedDate) {
            return displayedDate.plusDays(7L);
        }
    }
    ,
    DAY{

        @Override
        LocalDate getDisplayStart(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return localDate;
        }

        @Override
        LocalDate getDisplayEnd(LocalDate localDate, DayOfWeek firstDayOfWeek) {
            return this.getDisplayStart(localDate, firstDayOfWeek).plusDays(1L);
        }

        @Override
        public LocalDate decrement(LocalDate displayedDate) {
            return displayedDate.minusDays(1L);
        }

        @Override
        public LocalDate increment(LocalDate displayedDate) {
            return displayedDate.plusDays(1L);
        }
    };


    private static LocalDate floorToFirstDayOfWeek(LocalDate startOfYear, DayOfWeek firstDayOfWeek) {
        if (startOfYear.getDayOfWeek() == firstDayOfWeek) {
            return startOfYear;
        }
        return startOfYear.minusDays((startOfYear.getDayOfWeek().getValue() - firstDayOfWeek.getValue() + 7) % 7);
    }

    abstract LocalDate getDisplayStart(LocalDate var1, DayOfWeek var2);

    abstract LocalDate getDisplayEnd(LocalDate var1, DayOfWeek var2);

    public UiCalendarViewMode toUiCalendarViewMode() {
        return UiCalendarViewMode.valueOf((String)this.name());
    }

    public abstract LocalDate decrement(LocalDate var1);

    public abstract LocalDate increment(LocalDate var1);
}

