/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency.value;

import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiCurrencyUnit;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyCurrencyUnit;
import org.teamapps.ux.component.field.multicurrency.value.Jsr354CurrencyUnit;
import org.teamapps.ux.component.field.multicurrency.value.PlainCurrencyUnit;

public interface CurrencyUnit {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PlainCurrencyUnit forCode(String code) {
        return new PlainCurrencyUnit(code, null, null, null);
    }

    public static PlainCurrencyUnit from(String code, int fractionDigits, String name, String symbol) {
        return new PlainCurrencyUnit(code, fractionDigits, locale -> name, locale -> symbol);
    }

    public static PlainCurrencyUnit from(String code, Integer fractionDigits, Function<Locale, String> nameByLocale, Function<Locale, String> symbolByLocale) {
        return new PlainCurrencyUnit(code, fractionDigits, nameByLocale, symbolByLocale);
    }

    public static CurrencyUnit fromCurrency(Currency currency) {
        return new CurrencyCurrencyUnit(currency);
    }

    public static CurrencyUnit fromJsrCurrencyUnit(javax.money.CurrencyUnit currencyUnit) {
        return new Jsr354CurrencyUnit(currencyUnit);
    }

    public static List<CurrencyUnit> getAllAvailableFromJdk() {
        return Currency.getAvailableCurrencies().stream().sorted(Comparator.comparing(currency -> currency.getCurrencyCode())).map(c -> CurrencyUnit.fromCurrency(c)).collect(Collectors.toList());
    }

    public String getCode();

    default public int getFractionDigits() {
        return this.findCurrency().map(Currency::getDefaultFractionDigits).orElse(2);
    }

    default public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    default public String getSymbol(Locale locale) {
        return this.getCurrencySymbol(locale);
    }

    default public String getName() {
        return this.getName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    default public String getName(Locale locale) {
        return this.getCurrencyName(locale);
    }

    default public UiCurrencyUnit toUiCurrencyUnit(Locale locale) {
        UiCurrencyUnit uiCurrencyUnit = new UiCurrencyUnit();
        uiCurrencyUnit.setCode(this.getCode());
        uiCurrencyUnit.setFractionDigits(this.getFractionDigits());
        uiCurrencyUnit.setName(this.getName(locale));
        uiCurrencyUnit.setSymbol(this.getSymbol(locale));
        return uiCurrencyUnit;
    }

    private String getCurrencySymbol(Locale locale) {
        return this.findCurrency().map(c -> c.getSymbol(locale)).orElse(this.getCode());
    }

    private String getCurrencyName(Locale locale) {
        return this.findCurrency().map(c -> c.getDisplayName(locale)).orElse(this.getCode());
    }

    private Optional<Currency> findCurrency() {
        try {
            return Optional.of(Currency.getInstance(this.getCode()));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get Currency instance for code {}", (Object)this.getCode());
            return Optional.empty();
        }
    }
}

