/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload.simple;

import java.io.File;
import java.util.UUID;
import org.teamapps.dto.UiFileItem;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.upload.simple.FileItemState;
import org.teamapps.ux.component.field.upload.simple.SimpleFileField;
import org.teamapps.ux.session.CurrentSessionContext;

public class FileItem {
    public final Event<Void> onClicked = new Event();
    public final Event<Void> onRemoved = new Event();
    private final String uuid;
    private FileItemState state;
    private SimpleFileField fileField;
    private Icon icon;
    private String thumbnailUrl;
    private String fileName;
    private String description;
    private long size;
    private String linkUrl;
    private File file;

    public FileItem(String fileName, String description, long size) {
        this.uuid = UUID.randomUUID().toString();
        this.fileName = fileName;
        this.description = description;
        this.size = size;
    }

    FileItem(String uuid, String fileName, FileItemState state, String description, long size) {
        this.uuid = uuid;
        this.fileName = fileName;
        this.state = state;
        this.description = description;
        this.size = size;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.updateClientSideDisplay();
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        this.updateClientSideDisplay();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateClientSideDisplay();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateClientSideDisplay();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        this.updateClientSideDisplay();
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
        this.updateClientSideDisplay();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    private void updateClientSideDisplay() {
        this.fileField.handleFileItemChanged(this);
    }

    public void setDisplayData(String caption, String description, long size) {
        this.fileName = caption;
        this.description = description;
        this.size = size;
        this.updateClientSideDisplay();
    }

    String getUuid() {
        return this.uuid;
    }

    public FileItemState getState() {
        return this.state;
    }

    void setState(FileItemState state) {
        this.state = state;
    }

    void setFileField(SimpleFileField fileField) {
        this.fileField = fileField;
    }

    public UiFileItem createUiFileItem() {
        UiFileItem uiFileItem = new UiFileItem();
        uiFileItem.setUuid(this.uuid);
        uiFileItem.setFileName(this.fileName);
        uiFileItem.setDescription(this.description);
        uiFileItem.setSize(this.size);
        uiFileItem.setLinkUrl(this.linkUrl);
        uiFileItem.setIcon(CurrentSessionContext.get().resolveIcon(this.icon));
        uiFileItem.setThumbnail(this.thumbnailUrl);
        return uiFileItem;
    }
}

