/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiFormLayoutPolicy;
import org.teamapps.dto.UiGridForm;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.validator.MultiFieldValidator;
import org.teamapps.ux.component.form.FieldChangeEventData;
import org.teamapps.ux.component.form.LogicalForm;
import org.teamapps.ux.component.form.layoutpolicy.FormLayoutPolicy;

public abstract class AbstractForm<RECORD>
extends AbstractComponent
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractForm.class);
    public final Event<FieldChangeEventData> onFieldValueChanged = new Event();
    private final LogicalForm<RECORD> logicalForm = new LogicalForm();
    private final List<Component> children = new ArrayList<Component>();

    public void clearAllFields() {
        this.getFields().forEach(field -> field.setValue(null));
    }

    public void setFieldValue(String fieldName, Object value) {
        this.getFieldByPropertyName(fieldName).setValue(value);
    }

    public Object getFieldValue(String fieldName) {
        return this.getFieldByPropertyName(fieldName).getValue();
    }

    protected void addField(String propertyName, AbstractField<?> field) {
        this.addComponent(field);
        this.logicalForm.addField(propertyName, field);
        field.onValueChanged.addListener(value -> this.onFieldValueChanged.fire(new FieldChangeEventData(propertyName, field, value)));
    }

    protected void addComponent(Component component) {
        this.children.add(component);
        component.setParent(this);
        this.queueCommandIfRendered(() -> new UiGridForm.AddOrReplaceFieldCommand(this.getId(), component.createUiReference()));
    }

    public abstract List<FormLayoutPolicy> getLayoutPolicies();

    @Override
    public UiComponent createUiComponent() {
        List uiFields = this.logicalForm.getFields().values().stream().map(field -> field != null ? field.createUiReference() : null).collect(Collectors.toList());
        List<UiFormLayoutPolicy> uiLayoutPolicies = this.getUiFormLayoutPolicies();
        UiGridForm uiForm = new UiGridForm(uiFields, uiLayoutPolicies);
        this.mapAbstractUiComponentProperties((UiComponent)uiForm);
        return uiForm;
    }

    private void validateLayoutPolicies(List<UiFormLayoutPolicy> uiLayoutPolicies) {
        uiLayoutPolicies.stream().flatMap(policy -> policy.getSections().stream()).forEach(section -> {
            int numberOfRows = section.getRows().size();
            section.getFieldPlacements().stream().filter(fp -> fp.getRow() + fp.getRowSpan() > numberOfRows).forEach(fp -> LOGGER.error("FieldPlacement to non-existing row! Number of rows: " + numberOfRows + "; row: " + fp.getRow() + "; rowSpan: " + fp.getRowSpan()));
            int numberOfColumns = section.getColumns().size();
            section.getFieldPlacements().stream().filter(fp -> fp.getColumn() + fp.getColSpan() > numberOfColumns).forEach(fp -> LOGGER.error("FieldPlacement to non-existing column! Number of columns: " + numberOfColumns + "; column: " + fp.getColumn() + "; colSpan: " + fp.getColSpan()));
        });
    }

    private List<UiFormLayoutPolicy> getUiFormLayoutPolicies() {
        List<UiFormLayoutPolicy> uiFormLayoutPolicies = this.getLayoutPolicies().stream().map(layoutPolicy -> layoutPolicy != null ? layoutPolicy.createUiLayoutPolicy() : null).collect(Collectors.toList());
        this.validateLayoutPolicies(uiFormLayoutPolicies);
        return uiFormLayoutPolicies;
    }

    protected void updateLayoutPolicies() {
        List<UiFormLayoutPolicy> uiFormLayoutPolicies = this.getUiFormLayoutPolicies();
        this.queueCommandIfRendered(() -> new UiGridForm.UpdateLayoutPoliciesCommand(this.getId(), uiFormLayoutPolicies));
    }

    public void applyRecordValuesToFields(RECORD record) {
        this.logicalForm.applyRecordValuesToFields(record);
    }

    public void applyFieldValuesToRecord(RECORD record) {
        this.logicalForm.applyFieldValuesToRecord(record);
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.logicalForm.getPropertyProvider();
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.logicalForm.setPropertyProvider(propertyProvider);
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.logicalForm.setPropertyExtractor(propertyExtractor);
    }

    public PropertyInjector<RECORD> getPropertyInjector() {
        return this.logicalForm.getPropertyInjector();
    }

    public void setPropertyInjector(PropertyInjector<RECORD> propertyInjector) {
        this.logicalForm.setPropertyInjector(propertyInjector);
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_GRID_FORM_SECTION_COLLAPSED_STATE_CHANGED: {
                break;
            }
        }
    }

    private List<String> getPropertyNames() {
        return new ArrayList<String>(this.logicalForm.getFields().keySet());
    }

    public List<AbstractField<?>> getFields() {
        return new ArrayList(this.logicalForm.getFields().values());
    }

    public <V> AbstractField<V> getFieldByPropertyName(String propertyName) {
        return this.logicalForm.getFields().get(propertyName);
    }

    public List<Component> getAllChildren() {
        return this.children;
    }

    public void setSectionCollapsed(String sectionId, boolean collapsed) {
        this.queueCommandIfRendered(() -> new UiGridForm.SetSectionCollapsedCommand(this.getId(), sectionId, collapsed));
    }

    public void addMultiFieldValidator(MultiFieldValidator multiFieldValidator) {
        this.logicalForm.addMultiFieldValidator(multiFieldValidator);
    }

    public FieldMessage.Severity validate() {
        return this.logicalForm.validate();
    }

    public boolean isChangedByClient() {
        return this.getFields().stream().anyMatch(AbstractField::isValueChangedByClient);
    }
}

