/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishGridLayout;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishPlacement;

public class BootstrapishRow {
    private final BootstrapishGridLayout layout;
    private List<BootstrapishPlacement> placements = new ArrayList<BootstrapishPlacement>();

    public BootstrapishRow(BootstrapishGridLayout layout) {
        this.layout = layout;
    }

    public BootstrapishRow addPlacement(BootstrapishPlacement placement) {
        this.placements.add(placement);
        placement.getComponent().setParent(this.layout);
        return this;
    }

    public List<BootstrapishPlacement> getPlacements() {
        return this.placements;
    }

    public void setPlacements(List<BootstrapishPlacement> placements) {
        this.placements = placements;
    }

    public static class ChainBuilder {
        private final BootstrapishGridLayout parent;
        private final BootstrapishRow row;

        public ChainBuilder(BootstrapishGridLayout parent) {
            this.parent = parent;
            this.row = new BootstrapishRow(parent);
        }

        public BootstrapishPlacement.ChainBuilder addPlacement(Component component) {
            return new BootstrapishPlacement.ChainBuilder(component, this);
        }

        void addPlacement(BootstrapishPlacement placement) {
            this.row.addPlacement(placement);
        }

        public ChainBuilder addRow() {
            this.parent.addRow(this.row);
            return this.parent.addRow();
        }

        public BootstrapishGridLayout done() {
            this.parent.addRow(this.row);
            return this.parent;
        }
    }
}

