/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.progress;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.task.ObservableProgress;
import org.teamapps.ux.task.ProgressCompletableFuture;
import org.teamapps.ux.task.function.ProgressReportingRunnable;
import org.teamapps.ux.task.function.ProgressReportingSupplier;

public interface MultiProgressDisplay
extends Component {
    public void addProgress(Icon var1, String var2, ObservableProgress var3);

    default public <T> ProgressCompletableFuture<T> addTask(Icon icon, String taskName, ProgressReportingSupplier<T> supplier) {
        return this.addTask(icon, taskName, supplier, ProgressCompletableFuture.ASYNC_POOL);
    }

    default public <T> ProgressCompletableFuture<T> addTask(Icon icon, String taskName, ProgressReportingSupplier<T> supplier, Executor executor) {
        ProgressCompletableFuture<T> future = ProgressCompletableFuture.supplyAsync(supplier, executor);
        this.addProgress(icon, taskName, future.getProgress());
        return future;
    }

    default public ProgressCompletableFuture<Void> addTask(Icon icon, String taskName, ProgressReportingRunnable runnable) {
        return this.addTask(icon, taskName, runnable, ProgressCompletableFuture.ASYNC_POOL);
    }

    default public ProgressCompletableFuture<Void> addTask(Icon icon, String taskName, ProgressReportingRunnable runnable, Executor executor) {
        ProgressCompletableFuture<Void> future = ProgressCompletableFuture.runAsync(runnable, executor);
        this.addProgress(icon, taskName, future.getProgress());
        return future;
    }

    default public <T> ProgressCompletableFuture<T> addTask(Icon icon, String taskName, Supplier<T> supplier) {
        return this.addTask(icon, taskName, supplier, ProgressCompletableFuture.ASYNC_POOL);
    }

    default public <T> ProgressCompletableFuture<T> addTask(Icon icon, String taskName, Supplier<T> supplier, Executor executor) {
        ProgressCompletableFuture<T> future = ProgressCompletableFuture.supplyAsync(supplier, executor);
        this.addProgress(icon, taskName, future.getProgress());
        return future;
    }

    default public ProgressCompletableFuture<Void> addTask(Icon icon, String taskName, Runnable runnable) {
        return this.addTask(icon, taskName, runnable, ProgressCompletableFuture.ASYNC_POOL);
    }

    default public ProgressCompletableFuture<Void> addTask(Icon icon, String taskName, Runnable runnable, Executor executor) {
        ProgressCompletableFuture<Void> future = ProgressCompletableFuture.runAsync(runnable, executor);
        this.addProgress(icon, taskName, future.getProgress());
        return future;
    }
}

