/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.window;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiPanel;
import org.teamapps.dto.UiWindow;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.panel.Panel;

public class Window
extends Panel {
    public final Event<Void> onClosed = new Event();
    private boolean modal = false;
    private int width = 0;
    private int height = 0;
    private Color modalBackgroundDimmingColor = new RgbaColor(0, 0, 0, 0.2f);
    private boolean closeable;
    private boolean closeOnEscape;
    private boolean closeOnClickOutside;

    public Window() {
    }

    public Window(Component content) {
        this(0, 0, content);
    }

    public Window(int width, int height, Component content) {
        this(null, null, width, height, content);
    }

    public Window(Icon icon, String title, int width, int height, Component content) {
        this(icon, title, content, width, height, false, false, false);
    }

    public Window(Icon icon, String title, Component content, int width, int height, boolean closeable, boolean closeOnEscape, boolean closeOnClickOutside) {
        super(icon, title, content);
        this.width = width;
        this.height = height;
        this.closeable = closeable;
        this.closeOnEscape = closeOnEscape;
        this.closeOnClickOutside = closeOnClickOutside;
    }

    @Override
    public UiComponent createUiComponent() {
        UiWindow window = new UiWindow();
        this.mapUiPanelProperties((UiPanel)window);
        window.setModal(this.modal);
        window.setWidth(this.width);
        window.setHeight(this.height);
        if (this.height < 0) {
            window.setStretchContent(false);
        }
        window.setModalBackgroundDimmingColor(this.modalBackgroundDimmingColor != null ? this.modalBackgroundDimmingColor.toHtmlColorString() : null);
        window.setCloseable(this.closeable);
        window.setCloseOnClickOutside(this.closeOnClickOutside);
        window.setCloseOnEscape(this.closeOnEscape);
        return window;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_WINDOW_CLOSED: {
                this.onClosed.fire();
            }
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
        this.queueCommandIfRendered(() -> new UiWindow.SetModalCommand(this.getId(), modal));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.setSize(width, this.height);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.setSize(this.width, height);
    }

    public void enableAutoHeight() {
        this.setHeight(-1);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (height < 0) {
            this.setStretchContent(false);
        }
        this.queueCommandIfRendered(() -> new UiWindow.SetSizeCommand(this.getId(), width, height));
    }

    public Color getModalBackgroundDimmingColor() {
        return this.modalBackgroundDimmingColor;
    }

    public void setModalBackgroundDimmingColor(Color modalBackgroundDimmingColor) {
        this.modalBackgroundDimmingColor = modalBackgroundDimmingColor;
        this.queueCommandIfRendered(() -> new UiWindow.SetModalBackgroundDimmingColorCommand(this.getId(), modalBackgroundDimmingColor != null ? modalBackgroundDimmingColor.toHtmlColorString() : null));
    }

    public void show() {
        this.show(200);
    }

    public void show(int animationDuration) {
        this.render();
        this.queueCommandIfRendered(() -> new UiWindow.ShowCommand(this.getId(), animationDuration));
    }

    public void close() {
        this.close(200);
    }

    public void close(int animationDuration) {
        this.queueCommandIfRendered(() -> new UiWindow.CloseCommand(this.getId(), animationDuration));
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        this.queueCommandIfRendered(() -> new UiWindow.SetCloseableCommand(this.getId(), closeable));
    }

    public boolean isCloseOnEscape() {
        return this.closeOnEscape;
    }

    public void setCloseOnEscape(boolean closeOnEscape) {
        this.closeOnEscape = closeOnEscape;
        this.queueCommandIfRendered(() -> new UiWindow.SetCloseOnEscapeCommand(this.getId(), closeOnEscape));
    }

    public boolean isCloseOnClickOutside() {
        return this.closeOnClickOutside;
    }

    public void setCloseOnClickOutside(boolean closeOnClickOutside) {
        this.closeOnClickOutside = closeOnClickOutside;
        this.queueCommandIfRendered(() -> new UiWindow.SetCloseOnClickOutsideCommand(this.getId(), closeOnClickOutside));
    }
}

