/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.util.Locale;
import org.teamapps.dto.ClosedSessionHandlingType;
import org.teamapps.dto.UiConfiguration;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.DateTimeFormatDescriptor;
import org.teamapps.ux.session.StylingTheme;

public class SessionConfiguration {
    private ULocale locale = ULocale.US;
    private DateTimeFormatDescriptor dateFormat = DateTimeFormatDescriptor.forDate(DateTimeFormatDescriptor.FullLongMediumShortType.SHORT);
    private DateTimeFormatDescriptor timeFormat = DateTimeFormatDescriptor.forTime(DateTimeFormatDescriptor.FullLongMediumShortType.SHORT);
    private ZoneId timeZone = ZoneId.of("Europe/Berlin");
    private DayOfWeek firstDayOfWeek;
    private boolean optimizedForTouch = false;
    private String iconPath = "/icons";
    private StylingTheme theme = StylingTheme.DEFAULT;
    private ClosedSessionHandlingType closedSessionHandling = ClosedSessionHandlingType.MESSAGE_WINDOW;

    public static SessionConfiguration createForClientInfo(ClientInfo clientInfo) {
        boolean optimizedForTouch = false;
        StylingTheme theme = StylingTheme.DEFAULT;
        if (clientInfo.isMobileDevice()) {
            optimizedForTouch = true;
            theme = StylingTheme.MODERN;
        }
        return SessionConfiguration.create(ULocale.forLanguageTag((String)clientInfo.getPreferredLanguageIso()), ZoneId.of(clientInfo.getTimeZone()), theme, optimizedForTouch);
    }

    public static SessionConfiguration create(ULocale locale, ZoneId timeZone, StylingTheme theme, boolean optimizedForTouch) {
        SessionConfiguration config = new SessionConfiguration();
        config.setULocale(locale);
        config.setTimeZone(timeZone);
        config.setTheme(theme);
        config.setOptimizedForTouch(optimizedForTouch);
        return config;
    }

    private static DayOfWeek determineFirstDayOfWeek(ULocale locale) {
        return DayOfWeek.of(GregorianCalendar.getInstance((ULocale)locale).getFirstDayOfWeek()).minus(1L);
    }

    public UiConfiguration createUiConfiguration() {
        UiConfiguration config = new UiConfiguration();
        config.setLocale(this.locale.toLanguageTag());
        config.setOptimizedForTouch(this.optimizedForTouch);
        config.setThemeClassName(this.theme.getCssClass());
        return config;
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
    }

    public DateTimeFormatDescriptor getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatDescriptor dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateTimeFormatDescriptor getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateTimeFormatDescriptor timeFormat) {
        this.timeFormat = timeFormat;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek != null ? this.firstDayOfWeek : SessionConfiguration.determineFirstDayOfWeek(this.locale);
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public boolean isOptimizedForTouch() {
        return this.optimizedForTouch;
    }

    public void setOptimizedForTouch(boolean optimizedForTouch) {
        this.optimizedForTouch = optimizedForTouch;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public StylingTheme getTheme() {
        return this.theme;
    }

    public void setTheme(StylingTheme theme) {
        this.theme = theme;
    }

    public ClosedSessionHandlingType getClosedSessionHandling() {
        return this.closedSessionHandling;
    }

    public void setClosedSessionHandling(ClosedSessionHandlingType closedSessionHandling) {
        this.closedSessionHandling = closedSessionHandling;
    }
}

