/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload;

import java.io.File;
import java.io.InputStream;
import java.util.function.Supplier;
import org.teamapps.ux.component.field.upload.UploadedFileAccessException;

public class UploadedFile {
    private final String uuid;
    private final String name;
    private final long sizeInBytes;
    private final String mimeType;
    private final Supplier<InputStream> inputStreamSupplier;
    private final Supplier<File> fileSupplier;

    public UploadedFile(String uuid, String name, long sizeInBytes, String mimeType, Supplier<InputStream> inputStreamSupplier, Supplier<File> fileSupplier) {
        this.uuid = uuid;
        this.name = name;
        this.sizeInBytes = sizeInBytes;
        this.mimeType = mimeType;
        this.inputStreamSupplier = inputStreamSupplier;
        this.fileSupplier = fileSupplier;
    }

    public InputStream getAsInputStream() throws UploadedFileAccessException {
        return this.inputStreamSupplier.get();
    }

    public File getAsFile() {
        return this.fileSupplier.get();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Supplier<InputStream> getInputStreamSupplier() {
        return this.inputStreamSupplier;
    }

    public Supplier<File> getFileSupplier() {
        return this.fileSupplier;
    }

    public InputStream createInputStream() {
        return this.inputStreamSupplier.get();
    }
}

