/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.graph;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiHoseGraph;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.datapoints.HoseGraphData;
import org.teamapps.ux.component.timegraph.graph.AbstractGraph;
import org.teamapps.ux.component.timegraph.model.HoseGraphModel;

public class HoseGraph
extends AbstractGraph<HoseGraphData, HoseGraphModel> {
    private LineChartCurveType curveType;
    private float dataDotRadius;
    private Color centerLineColor;
    private Color lowerLineColor;
    private Color upperLineColor;
    private Color areaColor;
    private boolean stripedArea;

    public HoseGraph(HoseGraphModel model) {
        this(model, LineChartCurveType.MONOTONE, 2.0f, (Color)Color.fromRgb((int)73, (int)128, (int)192));
    }

    public HoseGraph(HoseGraphModel model, LineChartCurveType curveType, float dataDotRadius, Color centerLineColor) {
        this(model, curveType, dataDotRadius, centerLineColor, (Color)(centerLineColor instanceof RgbaColor ? ((RgbaColor)centerLineColor).withAlpha(((RgbaColor)centerLineColor).getAlpha() / 5.0f) : RgbaColor.TRANSPARENT));
    }

    public HoseGraph(HoseGraphModel model, LineChartCurveType curveType, float dataDotRadius, Color centerLineColor, Color areaColor) {
        this(model, curveType, dataDotRadius, centerLineColor, areaColor, false);
    }

    public HoseGraph(HoseGraphModel model, LineChartCurveType curveType, float dataDotRadius, Color centerLineColor, Color areaColor, boolean stripedArea) {
        super(model);
        this.curveType = curveType;
        this.dataDotRadius = dataDotRadius;
        this.centerLineColor = centerLineColor;
        this.lowerLineColor = centerLineColor instanceof RgbaColor ? ((RgbaColor)centerLineColor).withAlpha(((RgbaColor)centerLineColor).getAlpha() / 5.0f) : RgbaColor.TRANSPARENT;
        this.upperLineColor = centerLineColor instanceof RgbaColor ? ((RgbaColor)centerLineColor).withAlpha(((RgbaColor)centerLineColor).getAlpha() / 5.0f) : RgbaColor.TRANSPARENT;
        this.areaColor = areaColor;
        this.stripedArea = stripedArea;
    }

    public UiHoseGraph createUiFormat() {
        UiHoseGraph ui = new UiHoseGraph();
        this.mapAbstractLineChartDataDisplayProperties((UiGraph)ui);
        ui.setGraphType(this.curveType.toUiLineChartCurveType());
        ui.setDataDotRadius(this.dataDotRadius);
        ui.setMiddleLineColor(this.centerLineColor != null ? this.centerLineColor.toHtmlColorString() : null);
        ui.setLowerLineColor(this.lowerLineColor != null ? this.lowerLineColor.toHtmlColorString() : null);
        ui.setUpperLineColor(this.upperLineColor != null ? this.upperLineColor.toHtmlColorString() : null);
        ui.setAreaColor(this.areaColor != null ? this.areaColor.toHtmlColorString() : null);
        ui.setStripedArea(this.stripedArea);
        return ui;
    }

    public LineChartCurveType getCurveType() {
        return this.curveType;
    }

    public HoseGraph setCurveType(LineChartCurveType curveType) {
        this.curveType = curveType;
        this.fireChange();
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public HoseGraph setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        this.fireChange();
        return this;
    }

    public Color getCenterLineColor() {
        return this.centerLineColor;
    }

    public HoseGraph setCenterLineColor(Color centerLineColor) {
        this.centerLineColor = centerLineColor;
        this.fireChange();
        return this;
    }

    public Color getAreaColor() {
        return this.areaColor;
    }

    public HoseGraph setAreaColor(Color areaColor) {
        this.areaColor = areaColor;
        this.fireChange();
        return this;
    }

    public Color getLowerLineColor() {
        return this.lowerLineColor;
    }

    public HoseGraph setLowerLineColor(Color lowerLineColor) {
        this.lowerLineColor = lowerLineColor;
        this.fireChange();
        return this;
    }

    public Color getUpperLineColor() {
        return this.upperLineColor;
    }

    public HoseGraph setUpperLineColor(Color upperLineColor) {
        this.upperLineColor = upperLineColor;
        this.fireChange();
        return this;
    }
}

