/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession.commandbuffer;

import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.commandbuffer.CommandBuffer;
import org.teamapps.uisession.commandbuffer.CommandBufferException;
import org.teamapps.uisession.commandbuffer.CommandBufferLengthOverflowException;
import org.teamapps.uisession.commandbuffer.CommandBufferSizeOverflowException;

public class CommandBufferTest {
    @Test
    public void size() throws Exception {
        CommandBuffer buffer = new CommandBuffer(3, 1000000);
        Assert.assertEquals((long)0L, (long)buffer.getBufferedCommandsCount());
        buffer.addCommand(this.createCmd(1));
        Assert.assertEquals((long)1L, (long)buffer.getBufferedCommandsCount());
        buffer.addCommand(this.createCmd(2));
        Assert.assertEquals((long)2L, (long)buffer.getBufferedCommandsCount());
        buffer.addCommand(this.createCmd(3));
        Assert.assertEquals((long)3L, (long)buffer.getBufferedCommandsCount());
        buffer.consumeCommand();
        buffer.addCommand(this.createCmd(4));
        Assert.assertEquals((long)3L, (long)buffer.getBufferedCommandsCount());
        buffer.consumeCommand();
        buffer.addCommand(this.createCmd(5));
        Assert.assertEquals((long)3L, (long)buffer.getBufferedCommandsCount());
    }

    @Test
    public void consumeCommand() throws Exception {
        CommandBuffer buffer = new CommandBuffer(2, 1000000);
        buffer.addCommand(this.createCmd(1));
        Assert.assertEquals((long)1L, (long)buffer.consumeCommand().getId());
        Assert.assertNull((Object)buffer.consumeCommand());
        buffer.addCommand(this.createCmd(2));
        buffer.addCommand(this.createCmd(3));
        Assert.assertEquals((long)2L, (long)buffer.consumeCommand().getId());
        Assert.assertEquals((long)3L, (long)buffer.consumeCommand().getId());
        Assert.assertNull((Object)buffer.consumeCommand());
    }

    @Test
    public void throwsExceptionIfCommandsNextConsumableCommandGetsDeletedDueToBufferOverflow() throws Exception {
        CommandBuffer buffer = new CommandBuffer(3, 1000000);
        buffer.addCommand(this.createCmd(1));
        buffer.addCommand(this.createCmd(2));
        buffer.addCommand(this.createCmd(3));
        buffer.consumeCommand();
        buffer.addCommand(this.createCmd(4));
        Assertions.assertThatThrownBy(() -> buffer.addCommand(this.createCmd(5))).isInstanceOf(CommandBufferLengthOverflowException.class);
    }

    @Test
    public void rewindToCommand() throws Exception {
        CommandBuffer buffer = new CommandBuffer(5, 1000000);
        for (int i = 1; i <= 4; ++i) {
            buffer.addCommand(this.createCmd(i));
            if (i > 3) continue;
            buffer.consumeCommand();
        }
        Assert.assertEquals((long)4L, (long)buffer.getBufferedCommandsCount());
        buffer.rewindToCommand(2L);
        Assert.assertEquals((long)4L, (long)buffer.getBufferedCommandsCount());
        Assert.assertEquals((long)3L, (long)buffer.consumeCommand().getId());
        Assert.assertEquals((long)4L, (long)buffer.consumeCommand().getId());
        Assert.assertNull((Object)buffer.consumeCommand());
    }

    @Test
    public void rewindToCommand2() throws Exception {
        CommandBuffer buffer = new CommandBuffer(6, 1000000);
        for (int i = 1; i <= 7; ++i) {
            buffer.addCommand(this.createCmd(i));
            if (i > 5) continue;
            buffer.consumeCommand();
        }
        Assert.assertEquals((long)6L, (long)buffer.getBufferedCommandsCount());
        buffer.rewindToCommand(3L);
        Assert.assertEquals((long)6L, (long)buffer.getBufferedCommandsCount());
        Assert.assertEquals((long)4L, (long)buffer.consumeCommand().getId());
        Assert.assertEquals((long)5L, (long)buffer.consumeCommand().getId());
        Assert.assertEquals((long)6L, (long)buffer.consumeCommand().getId());
        Assert.assertEquals((long)7L, (long)buffer.consumeCommand().getId());
        Assert.assertNull((Object)buffer.consumeCommand());
    }

    @Test
    public void rewindToCommandWithLastReceivedIsMinusOne() throws Exception {
        CommandBuffer buffer = new CommandBuffer(6, 1000000);
        for (int i = 1; i <= 3; ++i) {
            buffer.addCommand(this.createCmd(i));
        }
        Assert.assertEquals((Object)true, (Object)buffer.rewindToCommand(-1L));
        Assert.assertEquals((long)1L, (long)buffer.consumeCommand().getId());
    }

    @Test
    public void rewindToCommandWithLastReceivedIsMinusOneFailsIfAlreadyOutOfBuffer() throws Exception {
        CommandBuffer buffer = new CommandBuffer(6, 1000000);
        for (int i = 1; i <= 7; ++i) {
            buffer.addCommand(this.createCmd(i));
            if (i > 2) continue;
            buffer.consumeCommand();
        }
        Assert.assertEquals((long)6L, (long)buffer.getBufferedCommandsCount());
        Assert.assertEquals((Object)false, (Object)buffer.rewindToCommand(-1L));
    }

    @Test
    public void purgeTillCommand() throws Exception {
        CommandBuffer buffer = new CommandBuffer(10, 1000000);
        for (int i = 1; i <= 15; ++i) {
            buffer.addCommand(this.createCmd(i));
            if (i > 11) continue;
            buffer.consumeCommand();
        }
        Assert.assertEquals((long)10L, (long)buffer.getBufferedCommandsCount());
        buffer.purgeTillCommand(8);
        Assert.assertEquals((long)8L, (long)buffer.getBufferedCommandsCount());
        buffer.purgeTillCommand(10);
        Assert.assertEquals((long)6L, (long)buffer.getBufferedCommandsCount());
        buffer.purgeTillCommand(11);
        Assert.assertEquals((long)5L, (long)buffer.getBufferedCommandsCount());
        buffer.purgeTillCommand(12);
        Assert.assertEquals((String)"must not purge next consumable command", (long)4L, (long)buffer.getBufferedCommandsCount());
        buffer.purgeTillCommand(100);
        Assert.assertEquals((String)"must not purge next consumable command", (long)4L, (long)buffer.getBufferedCommandsCount());
    }

    @Test
    public void rewindToCommandWhenTailGreaterThanNextConsumableAndRewindedCommandIsLeftFromNextConsumable() throws CommandBufferException {
        CommandBuffer buffer = new CommandBuffer(10, 1000000);
        for (int i = 0; i < 15; ++i) {
            buffer.addCommand(this.createCmd(i));
            buffer.consumeCommand();
        }
        buffer.addCommand(this.createCmd(15));
        buffer.rewindToCommand(13L);
        Assertions.assertThat((int)buffer.consumeCommand().getId()).isEqualTo(14);
    }

    @Test
    public void shouldThrowExceptionWhenMaxTotalSizeIsReached() throws CommandBufferException {
        CommandBuffer buffer = new CommandBuffer(100, 1000);
        for (int i = 0; i < 10; ++i) {
            buffer.addCommand(this.createCmd(i, 100));
        }
        Assertions.assertThatThrownBy(() -> buffer.addCommand(this.createCmd(10, 1))).isInstanceOf(CommandBufferSizeOverflowException.class);
    }

    @Test
    public void shouldPurgeACommandBeforeThrowingExceptionWhenMaxTotalSizeIsReached() throws CommandBufferException {
        int i;
        CommandBuffer buffer = new CommandBuffer(100, 1000);
        for (i = 0; i < 10; ++i) {
            buffer.addCommand(this.createCmd(i, 100));
        }
        Assertions.assertThat((int)buffer.getBufferedCommandsCount()).isEqualTo(10);
        for (i = 10; i < 20; ++i) {
            buffer.consumeCommand();
            buffer.addCommand(this.createCmd(10, 100));
        }
        Assertions.assertThat((int)buffer.getBufferedCommandsCount()).isEqualTo(10);
        Assertions.assertThatThrownBy(() -> buffer.addCommand(this.createCmd(11, 1))).isInstanceOf(CommandBufferSizeOverflowException.class);
    }

    @Test
    public void shouldPurgeMultipleCommandsBeforeThrowingExceptionWhenMaxTotalSizeIsReached() throws CommandBufferException {
        int i;
        CommandBuffer buffer = new CommandBuffer(100, 1000);
        for (i = 0; i < 10; ++i) {
            buffer.addCommand(this.createCmd(i, 100));
        }
        for (i = 0; i < 5; ++i) {
            buffer.consumeCommand();
        }
        Assertions.assertThat((int)buffer.getBufferedCommandsCount()).isEqualTo(10);
        buffer.addCommand(this.createCmd(10, 500));
        Assertions.assertThat((int)buffer.getBufferedCommandsCount()).isEqualTo(6);
        Assertions.assertThatThrownBy(() -> buffer.addCommand(this.createCmd(11, 1))).isInstanceOf(CommandBufferSizeOverflowException.class);
    }

    private CMD createCmd(int id) {
        return this.createCmd(id, 10);
    }

    private CMD createCmd(int id, int length) {
        return new CMD(id, StringUtils.repeat((char)'x', (int)length));
    }
}

