/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.AnnotationBasedRouteHandlerFactory;
import org.teamapps.ux.session.navigation.ParameterConverterProvider;
import org.teamapps.ux.session.navigation.annotation.PathParameter;
import org.teamapps.ux.session.navigation.annotation.QueryParameter;
import org.teamapps.ux.session.navigation.annotation.RoutingPath;
import org.teamapps.ux.session.navigation.annotation.RoutingPaths;

public class AnnotationBasedRouteHandlerFactoryTest {
    @Test
    public void annotatedMethod() {
        final AtomicBoolean wasInvoked = new AtomicBoolean();
        AnnotationBasedRouteHandlerFactory factory = new AnnotationBasedRouteHandlerFactory((ParamConverterProvider)new ParameterConverterProvider());
        List routers = factory.createRouteHandlers(new Object(this){
            final /* synthetic */ AnnotationBasedRouteHandlerFactoryTest this$0;
            {
                this.this$0 = this$0;
            }

            @RoutingPath(value="/apps/{appName}/item/{itemId}")
            public void myMethod(@PathParameter(value="appName") String appName, @PathParameter(value="itemId") Integer id, @QueryParameter(value="flag") Boolean flag) {
                wasInvoked.set(true);
                Assertions.assertThat((String)appName).isEqualTo("myApp");
                Assertions.assertThat((Integer)id).isEqualTo(123);
                Assertions.assertThat((Boolean)flag).isTrue();
            }
        });
        Assertions.assertThat((List)routers).extracting(r -> r.getPathTemplate()).containsExactlyInAnyOrder((Object[])new String[]{"/apps/{appName}/item/{itemId}"});
        ((AnnotationBasedRouteHandlerFactory.AnnotationBasedRouteHandler)routers.get(0)).handle("/apps/myApp/item/123", Map.of("appName", "myApp", "itemId", "123"), Map.of("flag", "true"));
        Assertions.assertThat((AtomicBoolean)wasInvoked).isTrue();
    }

    @Test
    public void multipleRoutingPaths() {
        final AtomicInteger invocationCount = new AtomicInteger();
        AnnotationBasedRouteHandlerFactory factory = new AnnotationBasedRouteHandlerFactory((ParamConverterProvider)new ParameterConverterProvider());
        List routers = factory.createRouteHandlers(new Object(this){
            final /* synthetic */ AnnotationBasedRouteHandlerFactoryTest this$0;
            {
                this.this$0 = this$0;
            }

            @RoutingPaths(value={@RoutingPath(value="/apps/{appName}/item/{itemId}"), @RoutingPath(value="/x/{itemId}")})
            public void myMethod(@PathParameter(value="appName") String appName, @PathParameter(value="itemId") Integer id, @QueryParameter(value="flag") Boolean flag) {
                invocationCount.incrementAndGet();
                if (flag.booleanValue()) {
                    Assertions.assertThat((String)appName).isEqualTo("myApp");
                    Assertions.assertThat((Integer)id).isEqualTo(123);
                } else {
                    Assertions.assertThat((Integer)id).isEqualTo(456);
                }
            }
        });
        Assertions.assertThat((List)routers).extracting(r -> r.getPathTemplate()).containsExactlyInAnyOrder((Object[])new String[]{"/apps/{appName}/item/{itemId}", "/x/{itemId}"});
        ((AnnotationBasedRouteHandlerFactory.AnnotationBasedRouteHandler)routers.get(0)).handle("/apps/myApp/item/123", Map.of("appName", "myApp", "itemId", "123"), Map.of("flag", "true"));
        ((AnnotationBasedRouteHandlerFactory.AnnotationBasedRouteHandler)routers.get(0)).handle("/x/456", Map.of("itemId", "456"), Map.of("flag", "false"));
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(2);
    }

    @Test
    public void classLevelPathAnnotation() {
        AnnotationBasedRouteHandlerFactory factory = new AnnotationBasedRouteHandlerFactory((ParamConverterProvider)new ParameterConverterProvider());
        MyRouter router = new MyRouter();
        List routers = factory.createRouteHandlers((Object)router);
        Assertions.assertThat((List)routers).extracting(r -> r.getPathTemplate()).containsExactlyInAnyOrder((Object[])new String[]{"/foo/{x}/bar/{y}"});
        ((AnnotationBasedRouteHandlerFactory.AnnotationBasedRouteHandler)routers.get(0)).handle("/foo/111/bar/yyy", Map.of("x", "111", "y", "yyy"), Map.of());
        Assertions.assertThat((boolean)router.wasInvoked).isTrue();
    }

    @Test
    public void shouldMakeMethodsAccessible() {
        final AtomicBoolean wasInvoked = new AtomicBoolean();
        List routeHandlers = new AnnotationBasedRouteHandlerFactory((ParamConverterProvider)new ParameterConverterProvider()).createRouteHandlers(new Object(this){
            final /* synthetic */ AnnotationBasedRouteHandlerFactoryTest this$0;
            {
                this.this$0 = this$0;
            }

            @RoutingPath(value="/")
            private void myMethod() {
                wasInvoked.set(true);
            }
        });
        ((AnnotationBasedRouteHandlerFactory.AnnotationBasedRouteHandler)routeHandlers.get(0)).handle("/", Map.of(), Map.of());
    }

    @RoutingPath(value="foo/{x}")
    public static class MyRouter {
        volatile boolean wasInvoked = false;

        @RoutingPath(value="bar/{y}")
        public void myMethod(@PathParameter(value="x") Integer x, @PathParameter(value="y") String y) {
            this.wasInvoked = true;
            Assertions.assertThat((Integer)x).isEqualTo(111);
            Assertions.assertThat((String)y).isEqualTo("yyy");
        }
    }
}

