/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsUploadManager;
import org.teamapps.icons.IconLibraryRegistry;
import org.teamapps.icons.IconProvider;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.uisession.TeamAppsSessionManager;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.ux.servlet.WebSocketCommunicationEndpoint;
import org.teamapps.webcontroller.WebController;

public class TeamAppsCore {
    private final TeamAppsConfiguration config;
    private final WebController webController;
    private final ObjectMapper objectMapper;
    private final TeamAppsSessionManager sessionManager;
    private final IconLibraryRegistry iconLibraryRegistry;
    private final TeamAppsUploadManager uploadManager;
    private final IconProvider iconProvider;
    private final WebSocketCommunicationEndpoint webSocketCommunicationEndpoint;

    public TeamAppsCore(TeamAppsConfiguration config, SequentialExecutorFactory sessionExecutorFactory, WebController webController) {
        this.config = config;
        this.webController = webController;
        this.objectMapper = TeamAppsObjectMapperFactory.create();
        this.iconLibraryRegistry = new IconLibraryRegistry();
        this.uploadManager = new TeamAppsUploadManager();
        this.iconProvider = new IconProvider(this.iconLibraryRegistry);
        this.sessionManager = new TeamAppsSessionManager(config, this.objectMapper, sessionExecutorFactory, webController, this.iconProvider, this.uploadManager);
        this.webSocketCommunicationEndpoint = new WebSocketCommunicationEndpoint(this.sessionManager, config);
    }

    public TeamAppsConfiguration getConfig() {
        return this.config;
    }

    public WebController getWebController() {
        return this.webController;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public TeamAppsSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public IconLibraryRegistry getIconLibraryRegistry() {
        return this.iconLibraryRegistry;
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public TeamAppsUploadManager getUploadManager() {
        return this.uploadManager;
    }

    public WebSocketCommunicationEndpoint getWebSocketCommunicationEndpoint() {
        return this.webSocketCommunicationEndpoint;
    }
}

