/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.collapsible;

import org.teamapps.dto.UiCollapsible;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;

public class Collapsible
extends AbstractComponent {
    public final Event<Boolean> onCollapseStateChanged = new Event();
    private Icon<?, ?> icon;
    private String caption;
    private Component content;
    private boolean collapsed;

    public Collapsible() {
        this(null, null, null);
    }

    public Collapsible(Icon<?, ?> icon, String caption) {
        this(icon, caption, null);
    }

    public Collapsible(Icon<?, ?> icon, String caption, Component content) {
        this.icon = icon;
        this.caption = caption;
        this.content = content;
    }

    public UiCollapsible createUiComponent() {
        UiCollapsible ui = new UiCollapsible();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setIcon(this.getSessionContext().resolveIcon(this.icon));
        ui.setCaption(this.caption);
        ui.setContent(this.content != null ? this.content.createUiReference() : null);
        ui.setCollapsed(this.collapsed);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_COLLAPSIBLE_COLLAPSE_STATE_CHANGED: {
                UiCollapsible.CollapseStateChangedEvent ce = (UiCollapsible.CollapseStateChangedEvent)event;
                this.onCollapseStateChanged.fire(ce.getCollapsed());
            }
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.content = content;
        this.queueCommandIfRendered(() -> new UiCollapsible.SetContentCommand(this.getId(), content != null ? content.createUiReference() : null));
    }

    public Icon<?, ?> getIcon() {
        return this.icon;
    }

    public void setIcon(Icon<?, ?> icon) {
        this.icon = icon;
        this.queueCommandIfRendered(() -> new UiCollapsible.SetIconAndCaptionCommand(this.getId(), this.getSessionContext().resolveIcon(icon), this.caption));
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.queueCommandIfRendered(() -> new UiCollapsible.SetIconAndCaptionCommand(this.getId(), this.getSessionContext().resolveIcon(this.icon), caption));
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.queueCommandIfRendered(() -> new UiCollapsible.SetCollapsedCommand(this.getId(), collapsed));
    }
}

