/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.Objects;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiFieldMessagePosition;
import org.teamapps.dto.UiFieldMessageSeverity;
import org.teamapps.dto.UiFieldMessageVisibilityMode;

public class FieldMessage {
    private final Severity severity;
    private final String message;
    private final Position position;
    private final Visibility visibility;

    public FieldMessage(Severity severity, String message) {
        this(null, null, severity, message);
    }

    public FieldMessage(Position position, Visibility visibility, Severity severity, String message) {
        this.position = position;
        this.visibility = visibility;
        this.severity = severity;
        this.message = message;
    }

    public UiFieldMessage createUiFieldMessage(Position defaultPosition, Visibility defaultVisibility) {
        return new UiFieldMessage(this.severity.toUiFieldMessageSeverity(), this.message, this.position != null ? this.position.toUiFieldMessagePosition() : defaultPosition.toUiFieldMessagePosition(), this.visibility != null ? this.visibility.toUiFieldMessageVisibilityMode() : defaultVisibility.toUiFieldMessageVisibilityMode());
    }

    public Position getPosition() {
        return this.position;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "FieldMessage{severity=" + String.valueOf((Object)this.severity) + ", message='" + this.message + "', position=" + String.valueOf((Object)this.position) + ", visibilityMode=" + String.valueOf((Object)this.visibility) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMessage that = (FieldMessage)o;
        return this.severity == that.severity && Objects.equals(this.message, that.message) && this.position == that.position && this.visibility == that.visibility;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.message, this.position, this.visibility});
    }

    public static enum Position {
        ABOVE,
        BELOW,
        POPOVER;


        public UiFieldMessagePosition toUiFieldMessagePosition() {
            return UiFieldMessagePosition.valueOf((String)this.name());
        }
    }

    public static enum Visibility {
        ALWAYS_VISIBLE,
        ON_FOCUS,
        ON_HOVER_OR_FOCUS;


        public UiFieldMessageVisibilityMode toUiFieldMessageVisibilityMode() {
            return UiFieldMessageVisibilityMode.valueOf((String)this.name());
        }
    }

    public static enum Severity {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;


        public UiFieldMessageSeverity toUiFieldMessageSeverity() {
            return UiFieldMessageSeverity.valueOf((String)this.name());
        }
    }
}

