/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.dto.UiWorkSpaceLayoutViewGroupItem;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.workspacelayout.ViewGroupPanelState;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.definition.ViewDefinition;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

public class WorkSpaceLayoutViewGroup
extends WorkSpaceLayoutItem {
    private final boolean persistent;
    private final List<WorkSpaceLayoutView> views = new ArrayList<WorkSpaceLayoutView>();
    private WorkSpaceLayoutView selectedView;
    private ViewGroupPanelState panelState = ViewGroupPanelState.NORMAL;

    public WorkSpaceLayoutViewGroup(WorkSpaceLayout workSpaceLayout) {
        this(null, null, false, workSpaceLayout);
    }

    public WorkSpaceLayoutViewGroup(String id, WorkSpaceLayout workSpaceLayout) {
        this(id, null, null, false, workSpaceLayout);
    }

    public WorkSpaceLayoutViewGroup(String id, boolean persistent, WorkSpaceLayout workSpaceLayout) {
        this(id, null, null, persistent, workSpaceLayout);
    }

    public WorkSpaceLayoutViewGroup(boolean persistent, WorkSpaceLayout workSpaceLayout) {
        this(null, null, persistent, workSpaceLayout);
    }

    public WorkSpaceLayoutViewGroup(List<WorkSpaceLayoutView> views, WorkSpaceLayoutView selectedView, boolean persistent, WorkSpaceLayout workSpaceLayout) {
        this(null, views, selectedView, persistent, workSpaceLayout);
    }

    public WorkSpaceLayoutViewGroup(String id, List<WorkSpaceLayoutView> views, WorkSpaceLayoutView selectedView, boolean persistent, WorkSpaceLayout workSpaceLayout) {
        super(id != null ? id : UUID.randomUUID().toString(), workSpaceLayout);
        if (views != null) {
            views.forEach(view -> {
                this.views.add((WorkSpaceLayoutView)view);
                view.setViewGroup(this);
            });
        }
        this.selectedView = selectedView != null ? selectedView : (CollectionUtils.isNotEmpty(views) ? views.get(0) : null);
        this.persistent = persistent;
        this.updateSelectedViewPanelWindowButtons();
    }

    private void updateSelectedViewPanelWindowButtons() {
        if (this.selectedView != null) {
            this.selectedView.updateWindowButtons(this.views.size() == 1);
        }
    }

    @Override
    public UiWorkSpaceLayoutItem createUiItem() {
        List viewNames = this.getAllViews().stream().map(WorkSpaceLayoutView::getId).collect(Collectors.toList());
        UiWorkSpaceLayoutViewGroupItem item = new UiWorkSpaceLayoutViewGroupItem(this.getId(), viewNames);
        item.setSelectedViewName(this.selectedView != null ? this.selectedView.getId() : null);
        item.setPanelState(this.panelState.toUiViewGroupPanelState());
        item.setPersistent(this.persistent);
        return item;
    }

    @Override
    public ViewGroupDefinition createLayoutDefinitionItem() {
        List<ViewDefinition> viewDefinitions = this.views.stream().map(view -> view.createViewDefinition()).collect(Collectors.toList());
        ViewDefinition selectedViewDefinition = this.selectedView != null ? this.selectedView.createViewDefinition() : null;
        return new ViewGroupDefinition(this.getId(), this.persistent, viewDefinitions, selectedViewDefinition, this.panelState);
    }

    @Override
    public List<WorkSpaceLayoutView> getAllViews() {
        return this.getViews();
    }

    @Override
    public List<WorkSpaceLayoutItem> getSelfAndAncestors() {
        return Collections.singletonList(this);
    }

    @Override
    protected void callHandleRemovedOnChildren() {
        this.views.forEach(view -> view.fireOnRemoved());
    }

    public List<WorkSpaceLayoutView> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public WorkSpaceLayoutView addView(Icon icon, String title, Component component) {
        return this.addView(icon, title, component, this.views.size(), false);
    }

    public WorkSpaceLayoutView addView(Icon icon, String title, Component component, int index, boolean select) {
        WorkSpaceLayoutView view = new WorkSpaceLayoutView(this.getWorkSpaceLayout(), icon, title, component);
        this.addView(view, index, select);
        return view;
    }

    public WorkSpaceLayoutViewGroup addView(WorkSpaceLayoutView view) {
        this.addView(view, this.views.size(), false);
        return this;
    }

    public WorkSpaceLayoutViewGroup addView(WorkSpaceLayoutView view, int index, boolean select) {
        this.addViewSilently(view, index, select);
        this.getWorkSpaceLayout().handleViewAddedToGroup(this, view, select);
        if (this.selectedView == null) {
            this.selectedView = view;
        }
        return this;
    }

    public WorkSpaceLayoutViewGroup removeView(WorkSpaceLayoutView view) {
        boolean removed = this.views.remove(view);
        view.setViewGroup(null);
        if (removed && this.getWorkSpaceLayout() != null) {
            this.getWorkSpaceLayout().handleViewRemovedViaApi(this, view);
        }
        if (!this.views.contains(this.selectedView)) {
            this.selectedView = this.views.size() > 0 ? this.views.get(0) : null;
        }
        return this;
    }

    public WorkSpaceLayoutView getSelectedView() {
        return this.selectedView;
    }

    public ViewGroupPanelState getPanelState() {
        return this.panelState;
    }

    public void setPanelState(ViewGroupPanelState panelState) {
        this.panelState = panelState;
        this.getWorkSpaceLayout().handleViewGroupPanelStateChangedViaApi(this, panelState);
    }

    public String toString() {
        return "WorkSpaceLayoutViewGroup{\n \"id\" : '" + this.getId() + "',\n \"viewNames\" : " + this.views.stream().map(WorkSpaceLayoutView::getId).collect(Collectors.joining(", ")) + ",\n \"selectedViewName\" : " + (this.selectedView != null ? this.selectedView.getId() : null) + ",\n \"persistent\" : " + this.persistent + ",\n \"panelState\" : " + String.valueOf((Object)this.panelState) + "\n}";
    }

    void handleViewSelectedByClient(String viewName) {
        this.selectedView = this.getViewById(viewName);
        this.updateSelectedViewPanelWindowButtons();
    }

    WorkSpaceLayoutView getViewById(String viewName) {
        return this.views.stream().filter(view -> Objects.equals(view.getId(), viewName)).findFirst().orElse(null);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setSelectedView(WorkSpaceLayoutView view) {
        this.selectedView = view;
        if (this.getWorkSpaceLayout() != null) {
            this.getWorkSpaceLayout().handleViewSelectedViaApi(this, view);
        }
    }

    void handleViewRemovedByClient(WorkSpaceLayoutView view) {
        this.views.remove(view);
        view.setViewGroup(null);
    }

    void addViewSilently(WorkSpaceLayoutView view, int index, boolean select) {
        if (this.views.size() <= index || this.views.get(index) != view) {
            this.views.remove(view);
            this.views.add(Math.min(this.views.size(), index), view);
            view.setViewGroup(this);
        }
        if (select && this.selectedView != view || this.views.size() == 1) {
            this.selectedView = view;
            this.updateSelectedViewPanelWindowButtons();
        }
    }

    void removeViewSilently(WorkSpaceLayoutView view) {
        this.views.remove(view);
    }

    void setSelectedViewSilently(WorkSpaceLayoutView selectedView) {
        this.selectedView = selectedView;
        this.updateSelectedViewPanelWindowButtons();
    }

    void setPanelStateSilently(ViewGroupPanelState panelState) {
        this.panelState = panelState;
    }
}

