/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout.definition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.definition.ViewDefinition;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

public abstract class LayoutItemDefinition {
    private final String id;

    public LayoutItemDefinition(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract List<ViewDefinition> getAllViews();

    public Set<String> getAllLayoutPositions() {
        HashSet<String> positionSet = new HashSet<String>();
        for (LayoutItemDefinition itemDefinition : this.getSelfAndAncestors()) {
            if (!(itemDefinition instanceof ViewGroupDefinition)) continue;
            String layoutPosition = itemDefinition.getId();
            positionSet.add(layoutPosition);
        }
        return positionSet;
    }

    public boolean containsLayoutPosition(String layoutPosition) {
        return this.getAllLayoutPositions().contains(layoutPosition);
    }

    public abstract List<ViewDefinition> getEffectivelyVisibleViews();

    public List<ViewDefinition> getEffectivelyInvisibleViews() {
        Set visibleViewNames = this.getEffectivelyVisibleViews().stream().map(ViewDefinition::getId).collect(Collectors.toSet());
        return this.getAllViews().stream().filter(view -> !visibleViewNames.contains(view.getId())).toList();
    }

    public abstract List<LayoutItemDefinition> getSelfAndAncestors();

    public abstract WorkSpaceLayoutItem createHeavyWeightItem(WorkSpaceLayout var1);
}

