/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.resource.ResourceWrapper;

public interface Resource {
    public static final Logger LOGGER = LoggerFactory.getLogger(Resource.class);

    public InputStream getInputStream();

    default public long getLength() {
        try {
            int len;
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                throw new IOException("Cannot get length of null resource: " + this.toString());
            }
            byte[] buf = new byte[4096];
            int totalLength = 0;
            while ((len = inputStream.read(buf)) != -1) {
                totalLength += len;
            }
            return totalLength;
        }
        catch (IOException e) {
            LOGGER.error("Exception while calculating resource length: " + this.toString(), (Throwable)e);
            return 0L;
        }
    }

    default public String getName() {
        return null;
    }

    default public Date getLastModified() {
        return new Date();
    }

    default public Date getExpires() {
        return new Date(System.currentTimeMillis() + 604800000L);
    }

    default public String getMimeType() {
        return null;
    }

    default public boolean isAttachment() {
        return false;
    }

    default public File getAsFile() {
        try {
            String name = this.getName() != null ? this.getName() : ".bin";
            File tempFile = File.createTempFile("temp", name);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
            IOUtils.copyLarge((InputStream)this.getInputStream(), (OutputStream)bos);
            bos.close();
            return tempFile;
        }
        catch (IOException e) {
            LOGGER.error("Exception while writing resource to file: " + this.toString(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    default public Resource lastModified(final Date lastModifiedDate) {
        return new ResourceWrapper(this, this){
            final /* synthetic */ Resource this$0;
            {
                this.this$0 = this$0;
                super(delegate);
            }

            @Override
            public Date getLastModified() {
                return lastModifiedDate;
            }
        };
    }

    default public Resource expiring(final Date expiryDate) {
        return new ResourceWrapper(this, this){
            final /* synthetic */ Resource this$0;
            {
                this.this$0 = this$0;
                super(delegate);
            }

            @Override
            public Date getExpires() {
                return expiryDate;
            }
        };
    }

    default public Resource withMimeType(final String mimeType) {
        return new ResourceWrapper(this, this){
            final /* synthetic */ Resource this$0;
            {
                this.this$0 = this$0;
                super(delegate);
            }

            @Override
            public String getMimeType() {
                return mimeType;
            }
        };
    }

    default public Resource asAttachment(final boolean attachment) {
        return new ResourceWrapper(this, this){
            final /* synthetic */ Resource this$0;
            {
                this.this$0 = this$0;
                super(delegate);
            }

            @Override
            public boolean isAttachment() {
                return attachment;
            }
        };
    }
}

