/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.event;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.event.Disposable;
import org.teamapps.event.Event;
import org.teamapps.testutil.UxTestUtil;
import org.teamapps.ux.session.SessionContext;

public class EventTest {
    @Test
    public void testAddRemoveConsumerNonBound() {
        Event event = new Event();
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
        Consumer<String> listener = s -> {};
        event.addListener(listener);
        Assert.assertEquals((long)1L, (long)event.getListeners().size());
        event.removeListener(listener);
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
    }

    @Test
    public void testAddRemoveConsumerBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
        Consumer<String> listener = s -> {};
        UxTestUtil.doWithMockedSessionContext(() -> {
            event.addListener(listener);
            Assert.assertEquals((long)1L, (long)event.getListeners().size());
        }).get();
        event.removeListener(listener);
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
    }

    @Test
    public void testAddRemoveRunnableNonBound() {
        Event event = new Event();
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
        Runnable listener = () -> {};
        event.addListener(listener);
        Assert.assertEquals((long)1L, (long)event.getListeners().size());
        event.removeListener(listener);
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
    }

    @Test
    public void testAddRemoveRunnableBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
        Runnable listener = () -> {};
        UxTestUtil.doWithMockedSessionContext(() -> {
            event.addListener(listener);
            Assert.assertEquals((long)1L, (long)event.getListeners().size());
        }).get();
        event.removeListener(listener);
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
    }

    @Test
    public void disposableShouldRemoveRunnableListener() {
        Event event = new Event();
        Disposable d = event.addListener(() -> {});
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        d.dispose();
        Assertions.assertThat((List)event.getListeners()).isEmpty();
    }

    @Test
    public void disposableShouldRemoveOnlyOneRunnableListener() {
        Event event = new Event();
        Runnable listener = () -> {};
        Disposable d = event.addListener(listener);
        Disposable d2 = event.addListener(listener);
        Assertions.assertThat((List)event.getListeners()).hasSize(2);
        d.dispose();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
    }

    @Test
    public void disposableShouldRemoveConsumerListener() {
        Event event = new Event();
        Disposable d = event.addListener(s -> {});
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        d.dispose();
        Assertions.assertThat((List)event.getListeners()).isEmpty();
    }

    @Test
    public void disposableShouldRemoveOnlyOneConsumerListener() {
        Event event = new Event();
        Consumer<String> listener = s -> {};
        Disposable d = event.addListener(listener);
        Disposable d2 = event.addListener(listener);
        Assertions.assertThat((List)event.getListeners()).hasSize(2);
        d.dispose();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
    }

    @Test
    public void disposableShouldRemoveRunnableListenerBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        AtomicReference d = new AtomicReference();
        UxTestUtil.doWithMockedSessionContext(() -> d.set(event.addListener(() -> {}))).get();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        ((Disposable)d.get()).dispose();
        Assertions.assertThat((List)event.getListeners()).isEmpty();
    }

    @Test
    public void disposableShouldRemoveOnlyOneRunnableListenerBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        AtomicReference d = new AtomicReference();
        UxTestUtil.doWithMockedSessionContext(() -> {
            Runnable listener = () -> {};
            d.set(event.addListener(listener));
            event.addListener(listener);
        }).get();
        Assertions.assertThat((List)event.getListeners()).hasSize(2);
        ((Disposable)d.get()).dispose();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
    }

    @Test
    public void disposableShouldRemoveConsumerListenerBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        AtomicReference d = new AtomicReference();
        UxTestUtil.doWithMockedSessionContext(() -> d.set(event.addListener(s -> {}))).get();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        ((Disposable)d.get()).dispose();
        Assertions.assertThat((List)event.getListeners()).isEmpty();
    }

    @Test
    public void disposableShouldRemoveOnlyOneConsumerListenerBoundToSessionContext() throws ExecutionException, InterruptedException {
        Event event = new Event();
        AtomicReference d = new AtomicReference();
        UxTestUtil.doWithMockedSessionContext(() -> {
            Consumer<String> listener = s -> {};
            d.set(event.addListener(listener));
            event.addListener(listener);
        }).get();
        Assertions.assertThat((List)event.getListeners()).hasSize(2);
        ((Disposable)d.get()).dispose();
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
    }

    @Test
    public void testBoundListenersGetRemovedWhenSessionContextGetsDestroyed() throws ExecutionException, InterruptedException {
        SessionContext sessionContext = UxTestUtil.createDummySessionContext();
        Event event = new Event();
        Assert.assertEquals((long)0L, (long)event.getListeners().size());
        Consumer<String> boundConsumerListener = s -> {};
        Runnable boundRunnableListener = () -> {};
        Consumer<String> unboundConsumerListener = s -> {};
        Runnable unboundRunnableListener = () -> {};
        event.addListener(unboundConsumerListener);
        Assert.assertEquals((long)1L, (long)event.getListeners().size());
        sessionContext.runWithContext(() -> {
            event.addListener(boundConsumerListener);
            event.addListener(boundRunnableListener);
            Assert.assertEquals((long)3L, (long)event.getListeners().size());
        }).get();
        event.addListener(unboundRunnableListener);
        Assert.assertEquals((long)4L, (long)event.getListeners().size());
        sessionContext.onDestroyed.fire();
        Assert.assertEquals((long)2L, (long)event.getListeners().size());
    }

    @Test
    public void testSelfDisposingEventListener() {
        Event event = new Event();
        AtomicInteger invocationCount = new AtomicInteger();
        event.addListener((i, disposable) -> {
            invocationCount.incrementAndGet();
            if (i == 3) {
                disposable.dispose();
            }
        });
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(0);
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        event.fire((Object)1);
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(1);
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        event.fire((Object)2);
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(2);
        Assertions.assertThat((List)event.getListeners()).hasSize(1);
        event.fire((Object)3);
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(3);
        Assertions.assertThat((List)event.getListeners()).hasSize(0);
        event.fire((Object)4);
        Assertions.assertThat((AtomicInteger)invocationCount).hasValue(3);
        Assertions.assertThat((List)event.getListeners()).hasSize(0);
    }

    @Test
    public void testSelfDisposingEventListenerBoundToSessionContext() throws ExecutionException, InterruptedException {
        SessionContext sessionContext = UxTestUtil.createDummySessionContext();
        Event event = new Event();
        AtomicInteger invocationCount = new AtomicInteger();
        sessionContext.runWithContext(() -> event.addListener((i, disposable) -> {
            invocationCount.incrementAndGet();
            if (i == 3) {
                disposable.dispose();
            }
        })).get();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertThat((AtomicInteger)invocationCount).hasValue(0);
            Assertions.assertThat((List)event.getListeners()).hasSize(1);
        });
        event.fire((Object)1);
        event.fire((Object)2);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertThat((AtomicInteger)invocationCount).hasValue(2);
            Assertions.assertThat((List)event.getListeners()).hasSize(1);
        });
        event.fire((Object)3);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertThat((AtomicInteger)invocationCount).hasValue(3);
            Assertions.assertThat((List)event.getListeners()).hasSize(0);
        });
        event.fire((Object)4);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertThat((AtomicInteger)invocationCount).hasValue(3);
            Assertions.assertThat((List)event.getListeners()).hasSize(0);
        });
    }
}

