/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.i18n.RankedTranslationProvider;
import org.teamapps.ux.i18n.ResourceBundleTranslationProvider;
import org.teamapps.ux.i18n.TranslationProvider;

public class RankedTranslationProviderTest {
    @Test
    public void shouldDelegate() {
        RankedTranslationProvider provider = new RankedTranslationProvider(new TranslationProvider[]{new ResourceBundleTranslationProvider("translations/Translations"), new TranslationProvider(){

            public String getTranslation(String key, Locale locale) {
                return "fallback " + key;
            }

            public Collection<String> getKeys(Locale locale) {
                return List.of();
            }
        }});
        Assertions.assertThat((String)provider.getTranslation("allLanguages", Locale.GERMAN)).isEqualTo("alle Sprachen");
        Assertions.assertThat((String)provider.getTranslation("asdf", Locale.GERMAN)).isEqualTo("fallback asdf");
    }

    @Test
    public void shouldThrowMissingResourceExceptionIfKeyNotPresentInAnyDelegates() {
        RankedTranslationProvider provider = new RankedTranslationProvider(new TranslationProvider[]{new ResourceBundleTranslationProvider("translations/Translations"), new ResourceBundleTranslationProvider("translations/Translations")});
        Assertions.assertThatThrownBy(() -> provider.getTranslation("nonExisting", Locale.GERMAN)).isInstanceOf(MissingResourceException.class);
    }
}

