/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.perspective;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.perspective.PerspectiveChangeHandler;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewChangeHandler;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class PerspectiveImpl
implements Perspective {
    private List<View> views = new ArrayList<View>();
    private List<ToolbarButtonGroup> workspaceToolbarButtonGroups = new ArrayList<ToolbarButtonGroup>();
    private List<PerspectiveChangeHandler> changeHandlers = new ArrayList<PerspectiveChangeHandler>();
    private LayoutItemDefinition layout;
    private View focusedView;

    public PerspectiveImpl(LayoutItemDefinition layout) {
        this.layout = layout;
    }

    @Override
    public void addPerspectiveChangeHandler(PerspectiveChangeHandler changeHandler) {
        this.changeHandlers.add(changeHandler);
    }

    @Override
    public void removePerspectiveChangeHandler(PerspectiveChangeHandler changeHandler) {
        this.changeHandlers.remove(changeHandler);
    }

    @Override
    public LayoutItemDefinition getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(LayoutItemDefinition layout) {
        this.layout = layout;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleLayoutChange(this, layout));
    }

    @Override
    public List<View> getViews() {
        return this.views;
    }

    @Override
    public List<View> getVisibleViews() {
        return this.views.stream().filter(view -> view.isVisible()).collect(Collectors.toList());
    }

    @Override
    public List<View> getVisibleAndLayoutReferencedViews() {
        Set<String> layoutPositions = this.layout.getAllLayoutPositions();
        return this.views.stream().filter(view -> view.isVisible()).filter(view -> layoutPositions.contains(view.getLayoutPosition())).collect(Collectors.toList());
    }

    @Override
    public void setFocusedView(View view) {
        view.focus();
        this.focusedView = view;
    }

    @Override
    public View getFocusedView() {
        return this.focusedView;
    }

    @Override
    public ToolbarButtonGroup addWorkspaceButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.add(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupAdded(this, buttonGroup));
        return buttonGroup;
    }

    @Override
    public void removeWorkspaceButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.remove(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupRemoved(this, buttonGroup));
    }

    @Override
    public List<ToolbarButtonGroup> getWorkspaceButtonGroups() {
        return this.workspaceToolbarButtonGroups;
    }

    @Override
    public View addView(final View view) {
        this.views.add(view);
        final PerspectiveImpl perspective = this;
        view.addViewChangeHandler(new ViewChangeHandler(){
            final /* synthetic */ PerspectiveImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handleVisibilityChange(boolean visible) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewVisibilityChange(perspective, view, visible));
            }

            @Override
            public void handleViewFocusRequest(boolean ensureVisible) {
                this.this$0.focusedView = view;
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewFocusRequest(perspective, view, ensureVisible));
            }

            @Override
            public void handleViewSizeChange(ViewSize viewSize) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewSizeChange(perspective, view, viewSize));
            }

            @Override
            public void handleViewTabTitleChange(String title) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewTabTitleChange(perspective, view, title));
            }

            @Override
            public void handleLayoutPositionChange(String position) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewLayoutPositionChange(perspective, view, position));
            }

            @Override
            public void handleWorkspaceButtonGroupAdded(ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupAdded(perspective, view, buttonGroup));
            }

            @Override
            public void handleWorkspaceButtonGroupRemoved(ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupRemoved(perspective, view, buttonGroup));
            }

            @Override
            public void handleSelect() {
                this.this$0.changeHandlers.forEach(ch -> ch.handleViewSelect(view));
            }
        });
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewAdded(this, view));
        return view;
    }

    @Override
    public void removeView(View view) {
        this.views.remove(view);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewRemoved(this, view));
    }
}

