/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.teamapps.ux.component.chat.AbstractChatDisplayModel;
import org.teamapps.ux.component.chat.ChatFile;
import org.teamapps.ux.component.chat.ChatMessage;
import org.teamapps.ux.component.chat.ChatMessageBatch;
import org.teamapps.ux.component.chat.ChatPhoto;
import org.teamapps.ux.component.chat.SimpleChatMessage;
import org.teamapps.ux.resolvable.Resolvable;

public class InMemoryChatDisplayModel
extends AbstractChatDisplayModel {
    private final AtomicInteger chatMessageIdCounter = new AtomicInteger();
    private final transient Object lock = new Object();
    private final ArrayList<ChatMessage> mutableList = new ArrayList();
    private volatile List<ChatMessage> snapshot = List.copyOf(this.mutableList);

    public InMemoryChatDisplayModel() {
    }

    private <T> T readFromSnapshot(Function<List<ChatMessage>, T> readOperation) {
        return readOperation.apply(this.snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T transformList(Function<List<ChatMessage>, T> operation) {
        T result;
        Object object = this.lock;
        synchronized (object) {
            result = operation.apply(this.mutableList);
            this.snapshot = List.copyOf(this.mutableList);
        }
        return result;
    }

    public InMemoryChatDisplayModel(CopyOnWriteArrayList<ChatMessage> messages) {
        this.transformList(chatMessages -> chatMessages.addAll(messages));
    }

    @Override
    public ChatMessage getChatMessageById(int id) {
        return this.readFromSnapshot(chatMessages -> {
            int index = Collections.binarySearch(chatMessages, new BinarySearchReferenceChatMessage(id), Comparator.comparing(ChatMessage::getId));
            return index >= 0 ? (ChatMessage)chatMessages.get(index) : null;
        });
    }

    @Override
    public ChatMessageBatch getPreviousMessages(Integer earliestKnownMessageId, int numberOfMessages) {
        if (earliestKnownMessageId == null) {
            return this.readFromSnapshot(chatMessages -> {
                int startIndex = Math.max(0, chatMessages.size() - numberOfMessages);
                return new ChatMessageBatch(chatMessages.subList(startIndex, chatMessages.size()), startIndex == 0);
            });
        }
        return this.readFromSnapshot(chatMessages -> {
            int searchResultIndex = Collections.binarySearch(chatMessages, new BinarySearchReferenceChatMessage(earliestKnownMessageId), Comparator.comparing(ChatMessage::getId));
            int firstKnownIndex = searchResultIndex >= 0 ? searchResultIndex : -(searchResultIndex + 1);
            int startIndex = Math.max(0, firstKnownIndex - numberOfMessages);
            return new ChatMessageBatch(chatMessages.subList(startIndex, firstKnownIndex), startIndex == 0);
        });
    }

    public ChatMessage addMessage(Resolvable userImage, String userNickname, String text) {
        return this.addMessage(userImage, userNickname, text, null, null, false);
    }

    public ChatMessage addMessage(Resolvable userImage, String userNickname, String text, List<ChatPhoto> photos, List<ChatFile> files, boolean deleted) {
        ChatMessageBatch chatMessageBatch = this.transformList(chatMessages -> {
            boolean firstMessage = chatMessages.size() == 0;
            SimpleChatMessage message = new SimpleChatMessage(this.chatMessageIdCounter.incrementAndGet(), userImage, userNickname, text, photos, files, deleted);
            chatMessages.add(message);
            return new ChatMessageBatch(Collections.singletonList(message), firstMessage);
        });
        this.onMessagesAdded.fire(chatMessageBatch);
        return chatMessageBatch.getMessages().get(0);
    }

    public void replaceAllMessages(List<ChatMessage> messages) {
        boolean wasChanged = this.transformList(chatMessages -> {
            boolean changed = chatMessages.size() != 0 || messages.size() != 0;
            chatMessages.clear();
            chatMessages.addAll(messages);
            return changed;
        });
        if (wasChanged) {
            this.onAllDataChanged.fire(null);
        }
    }

    public void deleteMessage(int messageId) {
        boolean wasRemoved = this.transformList(chatMessages -> {
            int searchResultIndex = Collections.binarySearch(chatMessages, new BinarySearchReferenceChatMessage(messageId), Comparator.comparing(ChatMessage::getId));
            if (searchResultIndex >= 0) {
                chatMessages.remove(searchResultIndex);
                return true;
            }
            return false;
        });
        if (wasRemoved) {
            this.onMessageDeleted.fire(messageId);
        }
    }

    public void updateMessage(ChatMessage chatMessage) {
        boolean wasChanged = this.transformList(chatMessages -> {
            int searchResultIndex = Collections.binarySearch(chatMessages, chatMessage, Comparator.comparing(ChatMessage::getId));
            if (searchResultIndex >= 0) {
                chatMessages.set(searchResultIndex, chatMessage);
                return true;
            }
            return false;
        });
        if (wasChanged) {
            this.onMessageChanged().fire(chatMessage);
        }
    }

    private static class BinarySearchReferenceChatMessage
    implements ChatMessage {
        private final int id;

        public BinarySearchReferenceChatMessage(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Resolvable getUserImage() {
            return null;
        }

        @Override
        public String getUserNickname() {
            return null;
        }

        @Override
        public String getText() {
            return null;
        }
    }
}

