/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiNotificationBar;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.notification.NotificationBarItem;
import org.teamapps.ux.component.notification.NotificationBarItemClosedEvent;

public class NotificationBar
extends AbstractComponent {
    public final Event<NotificationBarItemClosedEvent> onItemClosed = new Event();
    public final Event<NotificationBarItem> onItemClicked = new Event();
    public final Event<NotificationBarItem> onItemActionLinkClicked = new Event();
    private final Map<String, NotificationBarItem> itemsByUiId = new LinkedHashMap<String, NotificationBarItem>();

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_NOTIFICATION_BAR_ITEM_CLICKED: {
                UiNotificationBar.ItemClickedEvent e = (UiNotificationBar.ItemClickedEvent)event;
                NotificationBarItem item = this.itemsByUiId.get(e.getId());
                if (item == null) break;
                item.onClicked.fire();
                this.onItemClicked.fire(item);
                break;
            }
            case UI_NOTIFICATION_BAR_ITEM_ACTION_LINK_CLICKED: {
                UiNotificationBar.ItemActionLinkClickedEvent e = (UiNotificationBar.ItemActionLinkClickedEvent)event;
                NotificationBarItem item = this.itemsByUiId.get(e.getId());
                if (item == null) break;
                item.onActionLinkClicked.fire();
                this.onItemActionLinkClicked.fire(item);
                break;
            }
            case UI_NOTIFICATION_BAR_ITEM_CLOSED: {
                UiNotificationBar.ItemClosedEvent e = (UiNotificationBar.ItemClosedEvent)event;
                NotificationBarItem item = this.itemsByUiId.get(e.getId());
                if (item == null) break;
                NotificationBarItemClosedEvent.ClosingReason reason = e.getWasTimeout() ? NotificationBarItemClosedEvent.ClosingReason.TIMEOUT : NotificationBarItemClosedEvent.ClosingReason.USER;
                item.onClosed.fire(reason);
                this.onItemClosed.fire(new NotificationBarItemClosedEvent(item, reason));
                break;
            }
        }
    }

    @Override
    public UiComponent createUiComponent() {
        UiNotificationBar ui = new UiNotificationBar();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setInitialItems(this.itemsByUiId.values().stream().map(NotificationBarItem::toUiNotificationBarItem).collect(Collectors.toList()));
        return ui;
    }

    public void addItem(NotificationBarItem item) {
        if (this.itemsByUiId.containsValue(item)) {
            return;
        }
        this.itemsByUiId.put(item.getUiId(), item);
        item.setListener(() -> this.queueCommandIfRendered(() -> new UiNotificationBar.UpdateItemCommand(this.getId(), item.toUiNotificationBarItem())));
        this.queueCommandIfRendered(() -> new UiNotificationBar.AddItemCommand(this.getId(), item.toUiNotificationBarItem()));
    }

    public void removeItem(NotificationBarItem item) {
        if (this.itemsByUiId.remove(item.getUiId()) != null) {
            item.setListener(null);
            this.queueCommandIfRendered(() -> new UiNotificationBar.RemoveItemCommand(this.getId(), item.getUiId(), null));
        }
    }

    public List<NotificationBarItem> getItems() {
        return List.copyOf(this.itemsByUiId.values());
    }
}

