/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.ux.cache.record.EqualsAndHashCode;
import org.teamapps.ux.cache.record.EqualsHashCodeWrapper;

public class CustomEqualsAndHashCodeMap<K, V> {
    private final Map<EqualsHashCodeWrapper<K>, V> map = new HashMap<EqualsHashCodeWrapper<K>, V>();
    private final EqualsAndHashCode<K> equalsAndHashCode;

    public CustomEqualsAndHashCodeMap(EqualsAndHashCode<K> equalsAndHashCode) {
        this.equalsAndHashCode = equalsAndHashCode;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(this.keyWrapper(key));
    }

    public V computeIfAbsent(K key, Function<K, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        EqualsHashCodeWrapper<K> keyWrapper = this.keyWrapper(key);
        V existingValue = this.map.get(keyWrapper);
        if (existingValue == null) {
            V newValue = mappingFunction.apply(key);
            this.map.put(keyWrapper, newValue);
            return newValue;
        }
        return existingValue;
    }

    public V get(K key) {
        return this.map.get(this.keyWrapper(key));
    }

    public V getOrDefault(K key, V defaultValue) {
        return this.map.getOrDefault(this.keyWrapper(key), defaultValue);
    }

    public V remove(K key) {
        return this.map.remove(this.keyWrapper(key));
    }

    public void clear() {
        this.map.clear();
    }

    public void put(K key, V value) {
        this.map.put(this.keyWrapper(key), value);
    }

    public Set<K> keySet() {
        return this.map.keySet().stream().map(EqualsHashCodeWrapper::getRecord).collect(Collectors.toUnmodifiableSet());
    }

    private EqualsHashCodeWrapper<K> keyWrapper(K key) {
        return new EqualsHashCodeWrapper<K>(key, this.equalsAndHashCode);
    }
}

