/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import com.ibm.icu.util.ULocale;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiGraphData;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.dto.UiTimeChartZoomLevel;
import org.teamapps.dto.UiTimeGraph;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartMouseScrollZoomPanMode;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.TimePartitioningUnit;
import org.teamapps.ux.component.timegraph.ZoomEventData;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.graph.AbstractGraph;
import org.teamapps.ux.session.SessionContext;

public class TimeGraph
extends AbstractComponent {
    public final Event<ZoomEventData> onZoomed = new Event();
    public final Event<Interval> onIntervalSelected = new Event();
    private final List<GraphAndListener> graphsAndListeners = new ArrayList<GraphAndListener>();
    private List<TimePartitioning> zoomLevels = Arrays.asList(TimePartitioningUnit.YEAR, TimePartitioningUnit.HALF_YEAR, TimePartitioningUnit.QUARTER, TimePartitioningUnit.MONTH, TimePartitioningUnit.WEEK_MONDAY, TimePartitioningUnit.DAY, TimePartitioningUnit.HOURS_12, TimePartitioningUnit.HOURS_6, TimePartitioningUnit.HOURS_3, TimePartitioningUnit.HOUR, TimePartitioningUnit.MINUTES_30, TimePartitioningUnit.MINUTES_15, TimePartitioningUnit.MINUTES_5, TimePartitioningUnit.MINUTES_2, TimePartitioningUnit.MINUTE, TimePartitioningUnit.SECONDS_30, TimePartitioningUnit.SECONDS_10, TimePartitioningUnit.SECONDS_5, TimePartitioningUnit.SECONDS_2, TimePartitioningUnit.SECOND, TimePartitioningUnit.MILLISECOND_500, TimePartitioningUnit.MILLISECOND_200, TimePartitioningUnit.MILLISECOND_100, TimePartitioningUnit.MILLISECOND_50, TimePartitioningUnit.MILLISECOND_20, TimePartitioningUnit.MILLISECOND_10, TimePartitioningUnit.MILLISECOND_5, TimePartitioningUnit.MILLISECOND_2, TimePartitioningUnit.MILLISECOND);
    private int maxPixelsBetweenDataPoints = 50;
    private LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = LineChartMouseScrollZoomPanMode.ENABLED;
    private Interval displayedInterval;
    private double millisecondsPerPixel;
    private Interval selectedInterval;
    private ULocale locale = SessionContext.current().getULocale();
    private ZoneId timeZoneId = SessionContext.current().getTimeZone();

    private ArrayList<AbstractGraph<?, ?>> getGraphs() {
        return this.graphsAndListeners.stream().map(graphAndListener -> graphAndListener.graph).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addGraph(AbstractGraph<?, ?> graph) {
        ArrayList<AbstractGraph<?, ?>> graphs = this.getGraphs();
        graphs.add(graph);
        this.setGraphs(graphs);
    }

    public void setGraphs(List<? extends AbstractGraph<?, ?>> graphs) {
        this.graphsAndListeners.forEach(g -> g.graph.getModel().onDataChanged().removeListener(g.changeListener));
        this.graphsAndListeners.clear();
        graphs.forEach(graph -> {
            GraphAndListener graphAndListener = new GraphAndListener((AbstractGraph<?, ?>)graph, aVoid -> this.handleGraphDataChanged((AbstractGraph<?, ?>)graph));
            this.graphsAndListeners.add(graphAndListener);
            graph.setChangeListener(display -> this.queueCommandIfRendered(() -> new UiTimeGraph.AddOrUpdateGraphCommand(this.getId(), display.createUiFormat())));
            graph.getModel().onDataChanged().addListener(graphAndListener.changeListener);
        });
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetGraphsCommand(this.getId(), this.toUiLineFormats(graphs)));
        this.refresh();
    }

    private List<UiGraph> toUiLineFormats(List<? extends AbstractGraph<?, ?>> lineFormats) {
        return lineFormats.stream().map(AbstractGraph::createUiFormat).collect(Collectors.toList());
    }

    @Override
    public UiComponent createUiComponent() {
        Interval domainX;
        List<UiTimeChartZoomLevel> uiZoomLevels = this.createUiZoomlevels();
        this.displayedInterval = domainX = this.retrieveDomainX();
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).toUiLongInterval();
        UiTimeGraph uiTimeGraph = new UiTimeGraph(uiIntervalX, uiZoomLevels, this.maxPixelsBetweenDataPoints, this.toUiLineFormats(this.getGraphs()));
        uiTimeGraph.setLocale(this.locale.toLanguageTag());
        uiTimeGraph.setTimeZoneId(this.timeZoneId.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiTimeGraph);
        uiTimeGraph.setMouseScrollZoomPanMode(this.mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode());
        return uiTimeGraph;
    }

    private List<UiTimeChartZoomLevel> createUiZoomlevels() {
        return this.zoomLevels.stream().map(timePartitioning -> new UiTimeChartZoomLevel(timePartitioning.getApproximateMillisecondsPerPartition())).collect(Collectors.toList());
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TIME_GRAPH_ZOOMED: {
                UiTimeGraph.ZoomedEvent zoomedEvent = (UiTimeGraph.ZoomedEvent)event;
                if (zoomedEvent.getMillisecondsPerPixel() <= 0.0) {
                    return;
                }
                Interval displayedInterval = new Interval(zoomedEvent.getDisplayedInterval().getMin(), zoomedEvent.getDisplayedInterval().getMax());
                TimePartitioning timePartitioning = this.zoomLevels.get(zoomedEvent.getZoomLevelIndex());
                if (zoomedEvent.getNeededIntervalsByGraphId() != null) {
                    Map<String, List<Interval>> neededIntervalsByGraphId = zoomedEvent.getNeededIntervalsByGraphId().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(i -> new Interval(i.getMin(), i.getMax())).collect(Collectors.toList())));
                    Map<String, GraphData> data = this.retrieveData(displayedInterval, timePartitioning, neededIntervalsByGraphId);
                    this.queueCommandIfRendered(() -> new UiTimeGraph.AddDataCommand(this.getId(), zoomedEvent.getZoomLevelIndex(), this.convertToUiData(data)));
                }
                this.displayedInterval = displayedInterval;
                this.millisecondsPerPixel = zoomedEvent.getMillisecondsPerPixel();
                this.onZoomed.fire(new ZoomEventData(displayedInterval, zoomedEvent.getMillisecondsPerPixel(), timePartitioning));
                break;
            }
            case UI_TIME_GRAPH_INTERVAL_SELECTED: {
                Interval interval;
                UiTimeGraph.IntervalSelectedEvent selectedEvent = (UiTimeGraph.IntervalSelectedEvent)event;
                this.selectedInterval = interval = selectedEvent.getIntervalX() != null ? new Interval(selectedEvent.getIntervalX().getMin(), selectedEvent.getIntervalX().getMax()) : null;
                this.onIntervalSelected.fire(interval);
                break;
            }
        }
    }

    private Interval retrieveDomainX() {
        return this.graphsAndListeners.stream().map(g -> g.graph.getModel().getDomainX()).reduce(Interval::union).orElse(new Interval(0L, 1L));
    }

    private Map<String, GraphData> retrieveData(Interval displayedInterval, TimePartitioning timePartitioning, Map<String, List<Interval>> neededIntervalsByGraphId) {
        return this.graphsAndListeners.stream().filter(g -> neededIntervalsByGraphId.containsKey(g.graph.getId()) && ((List)neededIntervalsByGraphId.get(g.graph.getId())).size() > 0).collect(Collectors.toMap(g -> g.graph.getId(), g -> ((List)neededIntervalsByGraphId.get(g.graph.getId())).stream().reduce(Interval::union).map(interval -> g.graph.getModel().getData(timePartitioning, this.timeZoneId, (Interval)interval, displayedInterval)).orElseThrow()));
    }

    private Map<String, UiGraphData> convertToUiData(Map<String, GraphData> data) {
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((GraphData)e.getValue()).toUiGraphData()));
    }

    public void refresh() {
        Interval domainX = this.retrieveDomainX();
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).toUiLongInterval();
        this.queueCommandIfRendered(() -> new UiTimeGraph.ResetAllDataCommand(this.getId(), uiIntervalX, this.createUiZoomlevels()));
    }

    public void zoomTo(long minX, long maxX) {
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiTimeGraph.ZoomToCommand(this.getId(), new UiLongInterval(minX, maxX)), aVoid -> {
                this.displayedInterval = new Interval(minX, maxX);
            });
        } else {
            this.displayedInterval = new Interval(minX, maxX);
        }
    }

    public int getMaxPixelsBetweenDataPoints() {
        return this.maxPixelsBetweenDataPoints;
    }

    public void setMaxPixelsBetweenDataPoints(int maxPixelsBetweenDataPoints) {
        this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMaxPixelsBetweenDataPointsCommand(this.getId(), maxPixelsBetweenDataPoints));
    }

    public LineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
        return this.mouseScrollZoomPanMode;
    }

    public void setMouseScrollZoomPanMode(LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
        this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMouseScrollZoomPanModeCommand(this.getId(), mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode()));
    }

    public Interval getSelectedInterval() {
        return this.selectedInterval;
    }

    public void setSelectedInterval(Interval selectedInterval) {
        this.selectedInterval = selectedInterval;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetSelectedIntervalCommand(this.getId(), selectedInterval.toUiLongInterval()));
    }

    private void handleGraphDataChanged(AbstractGraph<?, ?> graph) {
        Interval domainX = this.retrieveDomainX();
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).toUiLongInterval();
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetIntervalXCommand(this.getId(), uiIntervalX));
        this.queueCommandIfRendered(() -> new UiTimeGraph.ResetGraphDataCommand(this.getId(), graph.getId()));
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        boolean changed = !Objects.equals(locale, this.locale);
        this.locale = locale;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(ZoneId timeZoneId) {
        boolean changed = !Objects.equals(timeZoneId, this.timeZoneId);
        this.timeZoneId = timeZoneId;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public List<TimePartitioning> getZoomLevels() {
        return this.zoomLevels;
    }

    public void setZoomLevels(List<TimePartitioning> zoomLevels) {
        this.zoomLevels = zoomLevels.stream().sorted(Comparator.comparing(TimePartitioning::getApproximateMillisecondsPerPartition).reversed()).collect(Collectors.toList());
        this.refresh();
    }

    private static class GraphAndListener {
        AbstractGraph<?, ?> graph;
        Consumer<Void> changeListener;

        public GraphAndListener(AbstractGraph<?, ?> graph, Consumer<Void> changeListener) {
            this.graph = graph;
            this.changeListener = changeListener;
        }
    }
}

