/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet.resourceprovider;

import java.util.function.Function;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;
import org.teamapps.ux.session.SessionContext;

public class TeamAppsSessionResourceProvider
implements ResourceProvider {
    private final Function<String, SessionContext> sessionContextLookup;

    public TeamAppsSessionResourceProvider(Function<String, SessionContext> sessionContextLookup) {
        this.sessionContextLookup = sessionContextLookup;
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        try {
            String[] parts;
            String uiSessionId;
            SessionContext sessionContext;
            if (relativeResourcePath == null) {
                return null;
            }
            if (relativeResourcePath.startsWith("/")) {
                relativeResourcePath = relativeResourcePath.substring(1);
            }
            if ((sessionContext = this.sessionContextLookup.apply(uiSessionId = (parts = relativeResourcePath.split("/"))[0])) == null) {
                return null;
            }
            int id = Integer.parseInt(parts[1].substring("res-".length()));
            return sessionContext.getBinaryResource(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

