/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;
import org.teamapps.dto.INIT;
import org.teamapps.dto.INIT_NOK;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMultiLineTextField;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.dto.UiWorkSpaceLayout;
import org.teamapps.json.TeamAppsObjectMapperFactory;

public class SerializationTest {
    private ObjectMapper teamAppsObjectMapper = TeamAppsObjectMapperFactory.create();

    @Test
    public void serializeViaJsonSimple() throws Exception {
        INIT init = new INIT("sessionId", null, 123);
        System.out.println(this.teamAppsObjectMapper.writeValueAsString((Object)init));
    }

    @Test
    public void serializeEnums() throws Exception {
        INIT_NOK init = new INIT_NOK(UiSessionClosingReason.SESSION_NOT_FOUND);
        System.out.println(this.teamAppsObjectMapper.writeValueAsString((Object)init));
    }

    @Test
    public void serializeCommands() throws Exception {
        UiWorkSpaceLayout.RefreshViewComponentCommand o = new UiWorkSpaceLayout.RefreshViewComponentCommand("componentId", "viewName", new UiClientObjectReference("asdf"));
        System.out.println(this.teamAppsObjectMapper.writeValueAsString((Object)o));
    }

    @Test
    public void deserializeViaJackson() throws Exception {
        UiObject uiObject = (UiObject)this.teamAppsObjectMapper.readValue("{\"_type\": \"INIT_NOK\", \"reason\":0}", UiObject.class);
        System.out.println(uiObject);
    }

    @Test
    public void deserializeEvents() throws Exception {
        UiEvent uiObject = (UiEvent)this.teamAppsObjectMapper.readValue("{\"componentId\":\"componentId\",\"_type\":\"UiGridForm.sectionCollapsedStateChanged\"}", UiEvent.class);
        System.out.println(uiObject);
    }

    @Test
    public void blah() throws Exception {
        UiMultiLineTextField.AppendCommand o = new UiMultiLineTextField.AppendCommand("id", "string", true);
        System.out.println(this.teamAppsObjectMapper.writeValueAsString((Object)o));
    }
}

