/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util.threading;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.common.util.ExceptionUtil;
import org.teamapps.util.threading.CompletableFutureChainSequentialExecutorFactory;

public class CompletableFutureChainSequentialExecutorFactoryTest {
    @Test
    public void executionOrderOneKey() throws Exception {
        int numberOfExecutions = 1000;
        CompletableFutureChainSequentialExecutorFactory executorFactory = new CompletableFutureChainSequentialExecutorFactory(2);
        IntArrayList executionOrderCheckingList = new IntArrayList();
        CyclicBarrier barrier = new CyclicBarrier(2);
        ExecutorService executor = executorFactory.createExecutor();
        int i = 0;
        while (i < numberOfExecutions) {
            int iFinal = i++;
            executor.execute(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderOneKey$1((IntList)executionOrderCheckingList, iFinal, numberOfExecutions, barrier));
        }
        barrier.await();
        this.checkIntListContents((IntList)executionOrderCheckingList, numberOfExecutions);
    }

    @Test
    public void executionOrderMultipleKey() throws Exception {
        int numberOfExecutions = 1000;
        CompletableFutureChainSequentialExecutorFactory executor = new CompletableFutureChainSequentialExecutorFactory(2);
        IntArrayList executionOrderCheckingList1 = new IntArrayList();
        IntArrayList executionOrderCheckingList2 = new IntArrayList();
        IntArrayList executionOrderCheckingList3 = new IntArrayList();
        CompletableFuture<Boolean> lastFuture1 = null;
        CompletableFuture<Boolean> lastFuture2 = null;
        CompletableFuture<Boolean> lastFuture3 = null;
        ExecutorService executor1 = executor.createExecutor();
        ExecutorService executor2 = executor.createExecutor();
        ExecutorService executor3 = executor.createExecutor();
        int i = 0;
        while (i < numberOfExecutions) {
            int iFinal = i++;
            lastFuture1 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$2((IntList)executionOrderCheckingList1, iFinal), executor1);
            lastFuture2 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$3((IntList)executionOrderCheckingList2, iFinal), executor2);
            lastFuture3 = CompletableFuture.supplyAsync(() -> CompletableFutureChainSequentialExecutorFactoryTest.lambda$executionOrderMultipleKey$4((IntList)executionOrderCheckingList3, iFinal), executor3);
        }
        CompletableFuture.allOf(new CompletableFuture[]{lastFuture1.thenRun(() -> this.lambda$executionOrderMultipleKey$5((IntList)executionOrderCheckingList1, numberOfExecutions)), lastFuture2.thenRun(() -> this.lambda$executionOrderMultipleKey$6((IntList)executionOrderCheckingList2, numberOfExecutions)), lastFuture3.thenRun(() -> this.lambda$executionOrderMultipleKey$7((IntList)executionOrderCheckingList3, numberOfExecutions))}).get();
    }

    @Test
    public void executionContinuesAfterException() throws Exception {
        CompletableFutureChainSequentialExecutorFactory executor = new CompletableFutureChainSequentialExecutorFactory(2);
        executor.createExecutor().execute(() -> {
            throw new RuntimeException();
        });
        CyclicBarrier barrier = new CyclicBarrier(2);
        boolean[] secondWasExecuted = new boolean[]{false};
        executor.createExecutor().execute(() -> {
            secondWasExecuted[0] = true;
            ExceptionUtil.softenExceptions(() -> barrier.await());
        });
        barrier.await();
        Assert.assertTrue((boolean)secondWasExecuted[0]);
    }

    private void checkIntListContents(IntList executionOrderCheckingList, int rangeMax) {
        Assertions.assertThat((int[])executionOrderCheckingList.toIntArray()).containsExactly(IntStream.range(0, rangeMax).toArray());
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$7(IntList executionOrderCheckingList3, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList3, numberOfExecutions);
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$6(IntList executionOrderCheckingList2, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList2, numberOfExecutions);
    }

    private /* synthetic */ void lambda$executionOrderMultipleKey$5(IntList executionOrderCheckingList1, int numberOfExecutions) {
        this.checkIntListContents(executionOrderCheckingList1, numberOfExecutions);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$4(IntList executionOrderCheckingList3, int iFinal) {
        return executionOrderCheckingList3.add(iFinal);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$3(IntList executionOrderCheckingList2, int iFinal) {
        return executionOrderCheckingList2.add(iFinal);
    }

    private static /* synthetic */ Boolean lambda$executionOrderMultipleKey$2(IntList executionOrderCheckingList1, int iFinal) {
        return executionOrderCheckingList1.add(iFinal);
    }

    private static /* synthetic */ void lambda$executionOrderOneKey$1(IntList executionOrderCheckingList, int iFinal, int numberOfExecutions, CyclicBarrier barrier) {
        executionOrderCheckingList.add(iFinal);
        if (iFinal == numberOfExecutions - 1) {
            ExceptionUtil.softenExceptions(() -> barrier.await());
        }
    }
}

