/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.SessionContextResourceManager;

public class SessionContextResourceManagerTest {
    @Test
    public void shouldCache() {
        SessionContextResourceManager manager = new SessionContextResourceManager("ui1");
        String resourceLink1 = manager.createResourceLink((Resource)new FileResource(new File("asdf.b")), null);
        String resourceLink2 = manager.createResourceLink((Resource)new FileResource(new File("asdf.b")), null);
        String resourceLink3 = manager.createResourceLink((Resource)new FileResource(new File("222.b")), null);
        Assertions.assertThat((String)resourceLink1).isEqualTo(resourceLink2);
        Assertions.assertThat((String)resourceLink3).isNotEqualTo((Object)resourceLink2);
    }

    @Test
    public void shouldCacheUsingUniqueIdentifier() {
        SessionContextResourceManager manager = new SessionContextResourceManager("ui1");
        String resourceLink1 = manager.createResourceLink((Resource)new FileResource(new File("asdf.b")), "uid1");
        String resourceLink2 = manager.createResourceLink((Resource)new FileResource(new File("999.b")), "uid1");
        String resourceLink3 = manager.createResourceLink((Resource)new FileResource(new File("asdf.b")), "uuid2");
        Assertions.assertThat((String)resourceLink1).isEqualTo(resourceLink2);
        Assertions.assertThat((String)resourceLink3).isNotEqualTo((Object)resourceLink1);
    }
}

