/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.ux.application.ApplicationChangeHandler;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.toolbar.AbstractToolContainer;
import org.teamapps.ux.component.toolbar.ToolAccordion;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class ResponsiveApplicationToolbar
implements ApplicationChangeHandler {
    private AbstractToolContainer toolbar;

    public ResponsiveApplicationToolbar() {
        SessionContext context = CurrentSessionContext.get();
        this.toolbar = context.getClientInfo().isMobileDevice() ? new ToolAccordion() : new Toolbar();
    }

    public AbstractToolContainer getToolbar() {
        return this.toolbar;
    }

    @Override
    public void handleApplicationViewAdded(ResponsiveApplication application, View view) {
        view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.addButtonGroup((ToolbarButtonGroup)group));
    }

    @Override
    public void handleApplicationViewRemoved(ResponsiveApplication application, View view) {
        view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.removeToolbarButtonGroup((ToolbarButtonGroup)group));
    }

    @Override
    public void handlePerspectiveChange(ResponsiveApplication application, Perspective perspective, Perspective previousPerspective, List<View> activeViews, List<View> addedViews, List<View> removedViews) {
        ArrayList<ToolbarButtonGroup> addGroups = new ArrayList<ToolbarButtonGroup>();
        ArrayList<ToolbarButtonGroup> removeGroups = new ArrayList<ToolbarButtonGroup>();
        addedViews.forEach(view -> addGroups.addAll(view.getWorkspaceButtonGroups()));
        addGroups.addAll(perspective.getWorkspaceButtonGroups());
        if (previousPerspective != null) {
            removedViews.forEach(view -> removeGroups.addAll(view.getWorkspaceButtonGroups()));
            removeGroups.addAll(previousPerspective.getWorkspaceButtonGroups());
            removeGroups.removeAll(addGroups);
        }
        removeGroups.stream().distinct().forEach(group -> this.toolbar.removeToolbarButtonGroup((ToolbarButtonGroup)group));
        addGroups.stream().distinct().forEach(group -> this.toolbar.addButtonGroup((ToolbarButtonGroup)group));
    }

    @Override
    public void handleApplicationToolbarButtonGroupAdded(ResponsiveApplication application, ToolbarButtonGroup buttonGroup) {
        this.toolbar.addButtonGroup(buttonGroup);
    }

    @Override
    public void handleApplicationToolbarButtonGroupRemoved(ResponsiveApplication application, ToolbarButtonGroup buttonGroup) {
        this.toolbar.removeToolbarButtonGroup(buttonGroup);
    }

    @Override
    public void handleLayoutChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, LayoutItemDefinition layout) {
    }

    @Override
    public void handleViewAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.addButtonGroup((ToolbarButtonGroup)group));
        }
    }

    @Override
    public void handleViewRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.removeToolbarButtonGroup((ToolbarButtonGroup)group));
        }
    }

    @Override
    public void handlePerspectiveToolbarButtonGroupAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, ToolbarButtonGroup buttonGroup) {
        if (isActivePerspective) {
            this.toolbar.addButtonGroup(buttonGroup);
        }
    }

    @Override
    public void handlePerspectiveToolbarButtonGroupRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, ToolbarButtonGroup buttonGroup) {
        if (isActivePerspective) {
            this.toolbar.removeToolbarButtonGroup(buttonGroup);
        }
    }

    @Override
    public void handleViewVisibilityChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean visible) {
        if (isActivePerspective) {
            if (visible) {
                view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.addButtonGroup((ToolbarButtonGroup)group));
            } else {
                view.getWorkspaceButtonGroups().forEach(group -> this.toolbar.removeToolbarButtonGroup((ToolbarButtonGroup)group));
            }
        }
    }

    @Override
    public void handleViewFocusRequest(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean ensureVisible) {
    }

    @Override
    public void handleViewSizeChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ViewSize viewSize) {
    }

    @Override
    public void handleViewTabTitleChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String title) {
    }

    @Override
    public void handleViewLayoutPositionChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String position) {
    }

    @Override
    public void handleViewWorkspaceToolbarButtonGroupAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
        if (isActivePerspective) {
            this.toolbar.addButtonGroup(buttonGroup);
        }
    }

    @Override
    public void handleViewWorkspaceToolbarButtonGroupRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
        if (isActivePerspective) {
            this.toolbar.removeToolbarButtonGroup(buttonGroup);
        }
    }

    @Override
    public void handleViewSelect(View view) {
    }
}

