/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.assembler;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.icons.Icon;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.AdditionalNavigationButton;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.mobile.NavigationBar;
import org.teamapps.ux.component.mobile.NavigationBarButton;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.toolbar.AbstractToolContainer;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.session.SessionContext;

public class MobileApplicationAssembler
implements ApplicationAssembler {
    private static final int PAGE_TRANSITION_ANIMATION_DURATION = 300;
    private final NavigationBarButton<BaseTemplateRecord> applicationLauncherButton;
    private final NavigationBarButton<BaseTemplateRecord> applicationTreeButton;
    private final NavigationBarButton<BaseTemplateRecord> applicationViewsButton;
    private final NavigationBarButton<BaseTemplateRecord> applicationToolbarButton;
    private final NavigationBarButton<BaseTemplateRecord> applicationBackButton;
    private final MobileLayout mobileLayout;
    private final NavigationBar<BaseTemplateRecord> navigationBar;
    private final SimpleItemView<Void> viewsItemView;
    private AbstractToolContainer mainToolbar;
    private View applicationLauncher;
    private View appTree;
    private final List<View> applicationViews = new ArrayList<View>();
    private List<View> perspectiveViews = new ArrayList<View>();
    private View activeView;

    public MobileApplicationAssembler() {
        this(SessionContext.current().getIcon(TeamAppsIconBundle.APPLICATION_LAUNCHER.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TREE.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.VIEWS.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TOOLBAR.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TOOLBAR.getKey()), null);
    }

    public MobileApplicationAssembler(Icon launcherIcon, Icon treeIcon, Icon viewsIcon, Icon toolbarIcon, Icon backIcon, List<AdditionalNavigationButton> additionalLeftButtons) {
        this.mobileLayout = new MobileLayout();
        this.navigationBar = new NavigationBar();
        this.viewsItemView = new SimpleItemView();
        this.navigationBar.preloadFanOutComponent(this.viewsItemView);
        this.mobileLayout.setNavigationBar(this.navigationBar);
        this.applicationLauncherButton = NavigationBarButton.create(launcherIcon);
        this.applicationTreeButton = NavigationBarButton.create(treeIcon);
        this.applicationViewsButton = NavigationBarButton.create(viewsIcon);
        this.applicationToolbarButton = NavigationBarButton.create(toolbarIcon);
        this.applicationBackButton = NavigationBarButton.create(backIcon);
        this.applicationLauncherButton.setVisible(false);
        this.applicationTreeButton.setVisible(false);
        if (additionalLeftButtons != null) {
            for (AdditionalNavigationButton leftButton : additionalLeftButtons) {
                NavigationBarButton<BaseTemplateRecord<String>> button = NavigationBarButton.create(leftButton.getIcon(), leftButton.getCaption());
                this.navigationBar.addButton(button);
                button.onClick.addListener(aVoid -> leftButton.getHandler().run());
            }
        }
        this.navigationBar.addButton(this.applicationLauncherButton);
        this.navigationBar.addButton(this.applicationTreeButton);
        this.navigationBar.addButton(this.applicationViewsButton);
        this.navigationBar.addButton(this.applicationToolbarButton);
        this.navigationBar.addButton(this.applicationBackButton);
        this.applicationLauncherButton.onClick.addListener(aVoid -> {
            this.navigationBar.hideFanOutComponent();
            this.mobileLayout.setContent(this.applicationLauncher.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
            this.updateActiveView(this.applicationLauncher);
        });
        this.applicationTreeButton.onClick.addListener(aVoid -> {
            this.navigationBar.hideFanOutComponent();
            PageTransition animation = PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT;
            if (this.activeView.equals(this.applicationLauncher)) {
                animation = PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT;
            }
            this.mobileLayout.setContent(this.appTree.getPanel(), animation, 300);
            this.updateActiveView(this.appTree);
        });
        this.applicationViewsButton.onClick.addListener(aVoid -> this.navigationBar.showOrHideFanoutComponent(this.viewsItemView));
        this.applicationToolbarButton.onClick.addListener(aVoid -> this.navigationBar.showOrHideFanoutComponent(this.mainToolbar));
        this.applicationBackButton.onClick.addListener(aVoid -> {
            this.navigationBar.hideFanOutComponent();
            this.goBack();
        });
        this.viewsItemView.onItemClicked.addListener(data -> this.navigationBar.hideFanOutComponent());
    }

    private void updateActiveView(View newActiveView) {
        if (this.activeView != null && this.activeView != newActiveView) {
            this.activeView.onEffectiveVisibilityChanged().fire(false);
        }
        this.activeView = newActiveView;
        newActiveView.onEffectiveVisibilityChanged().fire(true);
    }

    public void setApplicationLauncher(View applicationLauncher) {
        if (applicationLauncher == null) {
            this.applicationLauncherButton.setVisible(false);
        } else {
            this.mobileLayout.preloadView(applicationLauncher.getPanel());
            this.applicationLauncherButton.setVisible(true);
        }
        this.applicationLauncher = applicationLauncher;
    }

    public void setApplicationTree(View appTree) {
        this.appTree = appTree;
        this.applicationTreeButton.setVisible(true);
    }

    public void showView(View view) {
        if (this.activeView != null) {
            // empty if block
        }
        this.updateActiveView(view);
        this.mobileLayout.setContent(view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
    }

    public void showInitialView() {
        View view = null;
        if (!this.applicationViews.isEmpty()) {
            view = this.applicationViews.get(0);
        } else if (!this.perspectiveViews.isEmpty()) {
            view = this.perspectiveViews.get(0);
        }
        if (view != null) {
            this.mobileLayout.setContent(view.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
            this.updateActiveView(view);
        }
    }

    public void goBack() {
        int i;
        View view = null;
        for (i = 0; i < this.perspectiveViews.size(); ++i) {
            if (!this.perspectiveViews.get(i).equals(this.activeView)) continue;
            if (i > 0) {
                view = this.perspectiveViews.get(i - 1);
                break;
            }
            if (this.applicationViews.isEmpty()) break;
            view = this.applicationViews.get(this.applicationViews.size() - 1);
            break;
        }
        if (view == null) {
            for (i = 0; i < this.applicationViews.size(); ++i) {
                if (!this.applicationViews.get(i).equals(this.activeView)) continue;
                if (i > 0) {
                    view = this.applicationViews.get(i - 1);
                    break;
                }
                view = this.applicationLauncher;
                break;
            }
        }
        if (view != null) {
            this.updateActiveView(view);
            this.mobileLayout.setContent(this.activeView.getPanel(), PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 300);
        }
    }

    public void goForward() {
    }

    @Override
    public Component createApplication(ResponsiveApplication application) {
        return this.mobileLayout;
    }

    @Override
    public void setWorkSpaceToolbar(ResponsiveApplicationToolbar toolbar) {
        this.mainToolbar = toolbar.getToolbar();
        this.mainToolbar.onButtonClick.addListener(event -> {
            if (event.getDropDownButtonClickInfo() != null && !event.getDropDownButtonClickInfo().isOpening()) {
                this.navigationBar.hideFanOutComponent();
            }
        });
        this.navigationBar.preloadFanOutComponent(this.mainToolbar);
    }

    @Override
    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.navigationBar.getMultiProgressDisplay();
    }

    @Override
    public void handleApplicationViewAdded(ResponsiveApplication application, View view) {
        this.applicationViews.add(view);
        if (view.getComponent() instanceof Tree) {
            this.setApplicationTree(view);
        }
    }

    @Override
    public void handleApplicationViewRemoved(ResponsiveApplication application, View view) {
        this.applicationViews.remove(view);
    }

    @Override
    public void handlePerspectiveChange(ResponsiveApplication application, Perspective perspective, Perspective previousPerspective, List<View> activeViews, List<View> addedViews, List<View> removedViews) {
        addedViews.forEach(view -> this.mobileLayout.preloadView(view.getPanel()));
        this.perspectiveViews = activeViews;
        this.viewsItemView.removeAllGroups();
        SimpleItemGroup<Void> itemGroup = this.viewsItemView.addSingleColumnGroup(null, null);
        if (!this.applicationViews.isEmpty()) {
            this.applicationViews.forEach(view -> itemGroup.addItem(view.getPanel().getIcon(), (String)view.getPanel().getTitle(), null).onClick.addListener(aVoid -> this.showView((View)view)));
        }
        if (!this.perspectiveViews.isEmpty()) {
            this.perspectiveViews.forEach(view -> itemGroup.addItem(view.getPanel().getIcon(), (String)view.getPanel().getTitle(), null).onClick.addListener(aVoid -> this.showView((View)view)));
        }
        if (!this.perspectiveViews.isEmpty()) {
            View view2 = perspective.getFocusedView() != null ? perspective.getFocusedView() : this.perspectiveViews.get(0);
            this.updateActiveView(view2);
            this.mobileLayout.setContent(view2.getPanel(), PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 300);
        }
    }

    @Override
    public void handleLayoutChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, LayoutItemDefinition layout) {
    }

    @Override
    public void handleViewAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.mobileLayout.preloadView(view.getPanel());
            this.perspectiveViews.add(view);
        }
    }

    @Override
    public void handleViewRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.perspectiveViews.remove(view);
        }
    }

    @Override
    public void handleViewVisibilityChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean visible) {
        if (isActivePerspective) {
            // empty if block
        }
    }

    @Override
    public void handleViewFocusRequest(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean ensureVisible) {
        if (isActivePerspective) {
            this.showView(view);
        }
    }

    @Override
    public void handleViewSizeChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ViewSize viewSize) {
    }

    @Override
    public void handleViewTabTitleChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String title) {
    }

    @Override
    public void handleViewLayoutPositionChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String position) {
    }

    @Override
    public void handleApplicationToolbarButtonGroupAdded(ResponsiveApplication application, ToolbarButtonGroup buttonGroup) {
        this.applicationToolbarButton.setVisible(true);
    }
}

