/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceWrapper;

public class SessionContextResourceManager {
    public static final String BASE_PATH = "/files/";
    public static final String RESOURCE_LINK_ID_PREFIX = "res-";
    private static final Map<Class<? extends Resource>, Boolean> IMPLEMENTS_EQUAL_BY_RESOURCE_CLASS = new ConcurrentHashMap<Class<? extends Resource>, Boolean>();
    private final String sessionId;
    private final AtomicInteger linkIdGenerator = new AtomicInteger();
    private final Map<Integer, Resource> resourceByLinkId = new ConcurrentHashMap<Integer, Resource>();
    private final Map<Resource, String> resourceLinkByResource = new ConcurrentHashMap<Resource, String>();

    public SessionContextResourceManager(String sessionId) {
        this.sessionId = sessionId;
    }

    public Resource getBinaryResource(int resourceId) {
        return this.resourceByLinkId.get(resourceId);
    }

    public String createFileLink(File file) {
        if (file == null) {
            return null;
        }
        return this.createResourceLink(new FileResource(file), null);
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        if (resource == null) {
            return null;
        }
        String existingLink = this.resourceLinkByResource.get(resource);
        if (existingLink != null) {
            return existingLink;
        }
        if (uniqueIdentifier != null) {
            return this.createResourceLink(new UniqueIdentifierResourceWrapper(resource, uniqueIdentifier), null);
        }
        int linkId = this.createLinkId();
        String resourceLink = this.createLink(linkId);
        this.resourceByLinkId.put(linkId, resource);
        this.resourceLinkByResource.put(resource, resourceLink);
        return resourceLink;
    }

    private int createLinkId() {
        return this.linkIdGenerator.incrementAndGet();
    }

    private String createLink(int id) {
        return BASE_PATH + this.sessionId.toString() + "/res-" + id;
    }

    private static class UniqueIdentifierResourceWrapper
    extends ResourceWrapper {
        private final String uniqueIdentifier;

        public UniqueIdentifierResourceWrapper(Resource resource, String uniqueIdentifier) {
            super(resource);
            this.uniqueIdentifier = uniqueIdentifier;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UniqueIdentifierResourceWrapper that = (UniqueIdentifierResourceWrapper)o;
            return Objects.equals(this.uniqueIdentifier, that.uniqueIdentifier);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.uniqueIdentifier);
        }
    }
}

