/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.ux.application.ApplicationChangeHandler;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.perspective.PerspectiveChangeHandler;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class ResponsiveApplicationImpl
implements ResponsiveApplication {
    private final ApplicationAssembler assembler;
    private Component ui;
    private List<View> applicationViews = new ArrayList<View>();
    private List<Perspective> perspectives = new ArrayList<Perspective>();
    private Perspective activePerspective;
    private List<View> activeViews;
    private List<ToolbarButtonGroup> workspaceToolbarButtonGroups = new ArrayList<ToolbarButtonGroup>();
    private List<ApplicationChangeHandler> changeHandlers = new ArrayList<ApplicationChangeHandler>();
    private ResponsiveApplicationToolbar responsiveApplicationToolbar = new ResponsiveApplicationToolbar();

    public ResponsiveApplicationImpl(ApplicationAssembler assembler) {
        this.assembler = assembler;
        this.assembler.setWorkSpaceToolbar(this.responsiveApplicationToolbar);
        this.addApplicationChangeHandler(assembler);
        this.addApplicationChangeHandler(this.responsiveApplicationToolbar);
    }

    protected Component createUi() {
        return this.assembler.createApplication(this);
    }

    @Override
    public Component getUi() {
        if (this.ui == null) {
            this.ui = this.createUi();
        }
        return this.ui;
    }

    @Override
    public void addApplicationChangeHandler(ApplicationChangeHandler changeHandler) {
        this.changeHandlers.remove(changeHandler);
        this.changeHandlers.add(changeHandler);
    }

    @Override
    public void removeApplicationChangeHandler(ApplicationChangeHandler changeHandler) {
        this.changeHandlers.remove(changeHandler);
    }

    @Override
    public void addApplicationView(View view) {
        this.applicationViews.add(view);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationViewAdded(this, view));
    }

    @Override
    public void removeApplicationView(View view) {
        this.applicationViews.remove(view);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationViewRemoved(this, view));
    }

    @Override
    public List<View> getApplicationViews() {
        return this.applicationViews;
    }

    @Override
    public List<Perspective> getPerspectives() {
        return this.perspectives;
    }

    @Override
    public Perspective addPerspective(Perspective perspective) {
        final ResponsiveApplicationImpl application = this;
        this.perspectives.add(perspective);
        perspective.addPerspectiveChangeHandler(new PerspectiveChangeHandler(){
            final /* synthetic */ ResponsiveApplicationImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handleLayoutChange(Perspective perspective, LayoutItemDefinition layoutItemDefinition) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleLayoutChange(application, this.this$0.isActivePerspective(perspective), perspective, layoutItemDefinition));
            }

            @Override
            public void handleViewAdded(Perspective perspective, View view) {
                if (this.this$0.isActivePerspective(perspective)) {
                    this.this$0.checkViewChange(view, true);
                }
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewAdded(application, this.this$0.isActivePerspective(perspective), perspective, view));
            }

            @Override
            public void handleViewRemoved(Perspective perspective, View view) {
                if (this.this$0.isActivePerspective(perspective)) {
                    this.this$0.checkViewChange(view, false);
                }
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewRemoved(application, this.this$0.isActivePerspective(perspective), perspective, view));
            }

            @Override
            public void handlePerspectiveToolbarButtonGroupAdded(Perspective perspective, ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupAdded(application, this.this$0.isActivePerspective(perspective), perspective, buttonGroup));
            }

            @Override
            public void handlePerspectiveToolbarButtonGroupRemoved(Perspective perspective, ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupRemoved(application, this.this$0.isActivePerspective(perspective), perspective, buttonGroup));
            }

            @Override
            public void handleViewVisibilityChange(Perspective perspective, View view, boolean visible) {
                if (this.this$0.isActivePerspective(perspective)) {
                    this.this$0.checkViewChange(view, visible);
                }
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewVisibilityChange(application, this.this$0.isActivePerspective(perspective), perspective, view, visible));
            }

            @Override
            public void handleViewFocusRequest(Perspective perspective, View view, boolean ensureVisible) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewFocusRequest(application, this.this$0.isActivePerspective(perspective), perspective, view, ensureVisible));
            }

            @Override
            public void handleViewSizeChange(Perspective perspective, View view, ViewSize viewSize) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewSizeChange(application, this.this$0.isActivePerspective(perspective), perspective, view, viewSize));
            }

            @Override
            public void handleViewTabTitleChange(Perspective perspective, View view, String title) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewTabTitleChange(application, this.this$0.isActivePerspective(perspective), perspective, view, title));
            }

            @Override
            public void handleViewLayoutPositionChange(Perspective perspective, View view, String position) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewLayoutPositionChange(application, this.this$0.isActivePerspective(perspective), perspective, view, position));
            }

            @Override
            public void handleViewWorkspaceToolbarButtonGroupAdded(Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupAdded(application, this.this$0.isActivePerspective(perspective), perspective, view, buttonGroup));
            }

            @Override
            public void handleViewWorkspaceToolbarButtonGroupRemoved(Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
                this.this$0.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupRemoved(application, this.this$0.isActivePerspective(perspective), perspective, view, buttonGroup));
            }

            @Override
            public void handleViewSelect(View view) {
                this.this$0.changeHandlers.forEach(ch -> ch.handleViewSelect(view));
            }
        });
        return perspective;
    }

    private void checkViewChange(View view, boolean show) {
        if (this.activeViews != null) {
            if (show) {
                this.activeViews.add(view);
            } else {
                this.activeViews.remove(view);
            }
        }
    }

    private boolean isActivePerspective(Perspective perspective) {
        return this.activePerspective != null && this.activePerspective.equals(perspective);
    }

    @Override
    public void showPerspective(Perspective perspective) {
        if (!this.perspectives.contains(perspective)) {
            this.addPerspective(perspective);
        }
        List<View> previousViews = this.activeViews;
        this.activeViews = perspective.getVisibleAndLayoutReferencedViews();
        ArrayList<View> removedViews = new ArrayList<View>();
        ArrayList<View> addedViews = new ArrayList<View>();
        if (previousViews != null) {
            HashSet<View> commonViews = new HashSet<View>(this.activeViews);
            commonViews.retainAll(previousViews);
            addedViews.addAll(this.activeViews);
            addedViews.removeAll(commonViews);
            removedViews.addAll(previousViews);
            removedViews.removeAll(commonViews);
        } else {
            addedViews.addAll(this.activeViews);
        }
        Perspective previousPerspective = this.activePerspective;
        this.activePerspective = perspective;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveChange(this, perspective, previousPerspective, this.activeViews, addedViews, removedViews));
    }

    @Override
    public List<View> getActiveViews() {
        return this.activeViews;
    }

    @Override
    public Perspective getActivePerspective() {
        return this.activePerspective;
    }

    @Override
    public ToolbarButtonGroup addApplicationButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.add(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationToolbarButtonGroupAdded(this, buttonGroup));
        return buttonGroup;
    }

    @Override
    public void removeApplicationButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.remove(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationToolbarButtonGroupRemoved(this, buttonGroup));
    }

    @Override
    public List<ToolbarButtonGroup> getWorkspaceButtonGroups() {
        return this.workspaceToolbarButtonGroups;
    }

    @Override
    public void setToolbarBackgroundColor(Color backgroundColor) {
        this.responsiveApplicationToolbar.getToolbar().setBackgroundColor(backgroundColor);
    }

    @Override
    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.assembler.getMultiProgressDisplay();
    }
}

