/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.value.SortDirection;
import org.teamapps.ux.component.infiniteitemview.RecordsAddedEvent;
import org.teamapps.ux.component.table.AbstractTableModel;

public class ListTableModel<RECORD>
extends AbstractTableModel<RECORD> {
    private List<RECORD> list = new ArrayList<RECORD>();
    private Predicate<RECORD> filter = record -> true;
    private PropertyExtractor<RECORD> sortingPropertyExtractor = new BeanPropertyExtractor();

    public ListTableModel() {
    }

    public ListTableModel(List<RECORD> list) {
        this.list.addAll(list);
    }

    public void setList(List<RECORD> list) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.list = new ArrayList<RECORD>(list);
        this.onAllDataChanged.fire(null);
    }

    public List<RECORD> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void addRecord(RECORD record) {
        this.list.add(record);
        this.onRecordAdded.fire(new RecordsAddedEvent<RECORD>(this.list.size() - 1, List.of(record)));
    }

    public void addRecords(List<RECORD> records) {
        this.list.addAll(records);
        this.onAllDataChanged.fire(null);
    }

    @Override
    public int getCount() {
        if (this.filter == null) {
            return this.list.size();
        }
        return (int)this.list.stream().filter(this.filter).count();
    }

    @Override
    public List<RECORD> getRecords(int startIndex, int length) {
        if (this.filter == null && this.sorting == null) {
            return this.list.subList(startIndex, Math.min(this.list.size(), startIndex + length));
        }
        Stream stream = this.list.stream();
        if (this.filter != null) {
            stream = stream.filter(this.filter);
        }
        if (this.sorting != null && this.sortingPropertyExtractor != null) {
            stream = stream.sorted(this.valueExtractingComparator());
        }
        return stream.skip(startIndex).limit(length).collect(Collectors.toList());
    }

    private Comparator<RECORD> valueExtractingComparator() {
        Comparator comparator = (o1, o2) -> {
            Object v1 = this.sortingPropertyExtractor.getValue(o1, this.sorting.getFieldName());
            Object v2 = this.sortingPropertyExtractor.getValue(o2, this.sorting.getFieldName());
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            if (!(v1 instanceof Comparable) && !(v2 instanceof Comparable)) {
                return 0;
            }
            if (!(v1 instanceof Comparable)) {
                return 1;
            }
            if (!(v2 instanceof Comparable)) {
                return -1;
            }
            return ((Comparable)v1).compareTo(v2);
        };
        if (this.sorting.getSortDirection() == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public List<RECORD> getAllRecords() {
        return new ArrayList<RECORD>(this.list);
    }

    public Predicate<RECORD> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<RECORD> filter) {
        this.filter = filter;
        this.onAllDataChanged.fire(null);
    }

    public PropertyExtractor<RECORD> getSortingPropertyExtractor() {
        return this.sortingPropertyExtractor;
    }

    public void setSortingPropertyExtractor(PropertyExtractor<RECORD> sortingPropertyExtractor) {
        this.sortingPropertyExtractor = sortingPropertyExtractor;
    }
}

