/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.model;

import java.time.ZoneId;
import java.util.Objects;
import java.util.stream.Stream;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.datapoints.HoseGraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;
import org.teamapps.ux.component.timegraph.model.AbstractHoseGraphModel;
import org.teamapps.ux.component.timegraph.model.GraphModel;

public class DelegatingHoseModel
extends AbstractHoseGraphModel {
    private final GraphModel<LineGraphData> minModel;
    private final GraphModel<LineGraphData> avgModel;
    private final GraphModel<LineGraphData> maxModel;

    public DelegatingHoseModel(GraphModel<LineGraphData> minModel, GraphModel<LineGraphData> avgModel, GraphModel<LineGraphData> maxModel) {
        this.minModel = minModel;
        if (this.minModel != null) {
            this.minModel.onDataChanged().addListener(() -> this.onDataChanged().fire());
        }
        this.avgModel = avgModel;
        if (this.avgModel != null) {
            this.avgModel.onDataChanged().addListener(() -> this.onDataChanged().fire());
        }
        this.maxModel = maxModel;
        if (this.maxModel != null) {
            this.maxModel.onDataChanged().addListener(() -> this.onDataChanged().fire());
        }
    }

    public DelegatingHoseModel(GraphModel<LineGraphData> minModel, GraphModel<LineGraphData> maxModel) {
        this(minModel, null, maxModel);
    }

    @Override
    public Interval getDomainX() {
        return Stream.of(this.minModel, this.avgModel, this.maxModel).filter(Objects::nonNull).map(GraphModel::getDomainX).reduce(Interval::union).orElse(new Interval(0L, 1L));
    }

    @Override
    public HoseGraphData getData(TimePartitioning zoomLevel, ZoneId zoneId, Interval neededInterval, Interval displayedInterval) {
        final LineGraphData minDataPoints = this.getDataPointsOrNull(this.minModel, zoomLevel, zoneId, neededInterval, displayedInterval);
        final LineGraphData avgDataPoints = this.getDataPointsOrNull(this.avgModel, zoomLevel, zoneId, neededInterval, displayedInterval);
        final LineGraphData maxDataPoints = this.getDataPointsOrNull(this.maxModel, zoomLevel, zoneId, neededInterval, displayedInterval);
        return new HoseGraphData(){
            final /* synthetic */ DelegatingHoseModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public LineGraphData getMiddleLineData() {
                return avgDataPoints;
            }

            @Override
            public LineGraphData getLowerLineData() {
                return minDataPoints;
            }

            @Override
            public LineGraphData getUpperLineData() {
                return maxDataPoints;
            }
        };
    }

    private LineGraphData getDataPointsOrNull(GraphModel<LineGraphData> model, TimePartitioning zoomLevel, ZoneId zoneId, Interval neededInterval, Interval displayedInterval) {
        return model != null ? model.getData(zoomLevel, zoneId, neededInterval, displayedInterval) : null;
    }
}

