/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet.resourceprovider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.icons.IconProvider;
import org.teamapps.icons.IconResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;

public class IconResourceProvider
implements ResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Date lastModifiedDate = new Date();
    private final IconProvider iconResolver;

    public IconResourceProvider(IconProvider iconProviderDispatcher) {
        this.iconResolver = iconProviderDispatcher;
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        int size;
        String[] parts;
        String qualifiedEncodedIcon;
        IconResource iconResource;
        if (relativeResourcePath == null) {
            return null;
        }
        if (relativeResourcePath.startsWith("/")) {
            relativeResourcePath = relativeResourcePath.substring(1);
        }
        if (relativeResourcePath.endsWith("/")) {
            relativeResourcePath = relativeResourcePath.substring(0, relativeResourcePath.length() - 1);
        }
        if ((iconResource = this.iconResolver.loadIcon(qualifiedEncodedIcon = (parts = relativeResourcePath.split("@"))[0], size = parts.length > 1 ? this.getInt(parts[parts.length - 1]) : -1)) != null) {
            return new Resource(){
                final /* synthetic */ IconResourceProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(iconResource.getBytes());
                }

                @Override
                public long getLength() {
                    return iconResource.getLength();
                }

                @Override
                public Date getLastModified() {
                    return lastModifiedDate;
                }

                @Override
                public Date getExpires() {
                    return new Date(System.currentTimeMillis() + 5184000000L);
                }

                @Override
                public String getMimeType() {
                    return iconResource.getMimeType();
                }
            };
        }
        return null;
    }

    private int getInt(String s) {
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

