/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.event;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.event.EventListener;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.LockableSessionContext;
import org.teamapps.ux.session.SessionContext;

public class Event<EVENT_DATA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private List<EventListener<EVENT_DATA>> listeners = new CopyOnWriteArrayList<EventListener<EVENT_DATA>>();
    private EVENT_DATA lastEventData;

    public void addListener(EventListener<EVENT_DATA> listener) {
        LockableSessionContext currentSessionContext = CurrentSessionContext.getOrNull();
        this.listeners.add(new SessionContextAwareEventListener<EVENT_DATA>(currentSessionContext, listener));
        if (currentSessionContext != null) {
            this.removeWhenSessionDestroyed(listener, currentSessionContext);
        }
    }

    private void removeWhenSessionDestroyed(EventListener<EVENT_DATA> listener, SessionContext currentSessionContext) {
        if (this != currentSessionContext.onDestroyed()) {
            WeakReference<EventListener<EVENT_DATA>> listenerWeakReference = new WeakReference<EventListener<EVENT_DATA>>(listener);
            currentSessionContext.onDestroyed().listeners.add(aVoid -> {
                EventListener l = (EventListener)listenerWeakReference.get();
                if (l != null) {
                    this.removeListener(l);
                }
            });
        }
    }

    public void removeListener(EventListener<EVENT_DATA> listener) {
        this.listeners.remove(new SessionContextAwareEventListener<EVENT_DATA>(listener));
    }

    public void fire(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (EventListener<EVENT_DATA> listener : this.listeners) {
            listener.onEvent(eventData);
        }
    }

    public void fireIfChanged(EVENT_DATA eventData) {
        if (!Objects.equals(this.lastEventData, eventData)) {
            this.fire(eventData);
        }
    }

    public <T> Event<T> converted(Function<EVENT_DATA, T> converter) {
        Event newEvent = new Event();
        this.addListener(data -> newEvent.fire(converter.apply(data)));
        return newEvent;
    }

    private static class SessionContextAwareEventListener<EVENT_DATA>
    implements EventListener<EVENT_DATA> {
        private final SessionContext sessionContext;
        private final EventListener<EVENT_DATA> delegate;

        public SessionContextAwareEventListener(SessionContext sessionContext, EventListener<EVENT_DATA> delegate) {
            this.sessionContext = sessionContext;
            this.delegate = delegate;
        }

        public SessionContextAwareEventListener(EventListener<EVENT_DATA> delegate) {
            this(null, delegate);
        }

        @Override
        public void onEvent(EVENT_DATA eventData) {
            if (this.sessionContext != null) {
                this.sessionContext.runWithContext(() -> this.delegate.onEvent(eventData));
            } else {
                this.delegate.onEvent(eventData);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionContextAwareEventListener that = (SessionContextAwareEventListener)o;
            return this.delegate != null ? this.delegate.equals(that.delegate) : that.delegate == null;
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }
}

