/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiShapeProperties;

public class ShapeProperties {
    private Color strokeColor = Color.BLACK;
    private float strokeOpacity = 0.8f;
    private float strokeWeight = 2.0f;
    private String strokeDashArray;
    private Color fillColor = Color.BLUE;
    private float fillOpacity = 0.4f;

    public ShapeProperties(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public ShapeProperties(Color strokeColor, float strokeWeight) {
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
    }

    public ShapeProperties(Color strokeColor, float strokeWeight, String strokeDashArray) {
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.strokeDashArray = strokeDashArray;
    }

    public ShapeProperties(Color strokeColor, float strokeOpacity, float strokeWeight, Color fillColor, float fillOpacity) {
        this.strokeColor = strokeColor;
        this.strokeOpacity = strokeOpacity;
        this.strokeWeight = strokeWeight;
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(float strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setStrokeWeight(float strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(float fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public String getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        this.strokeDashArray = strokeDashArray;
    }

    public UiShapeProperties createUiShapeProperties() {
        UiShapeProperties properties = new UiShapeProperties();
        properties.setFillColor(this.fillColor.toHtmlColorString());
        properties.setFillOpacity(this.fillOpacity);
        properties.setStrokeColor(this.strokeColor.toHtmlColorString());
        properties.setStrokeOpacity(this.strokeOpacity);
        properties.setStrokeWeight(this.strokeWeight);
        properties.setStrokeDashArray(this.strokeDashArray);
        return properties;
    }
}

