/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.textcolormarker;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiTextColorMarkerField;
import org.teamapps.dto.UiTextColorMarkerFieldMarkerDefinition;
import org.teamapps.dto.UiTextColorMarkerFieldValue;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.textcolormarker.IllegalTextColorMarkerException;
import org.teamapps.ux.component.field.textcolormarker.TextColorMarker;
import org.teamapps.ux.component.field.textcolormarker.TextColorMarkerDefinition;
import org.teamapps.ux.component.field.textcolormarker.TextColorMarkerFieldValue;
import org.teamapps.ux.component.field.textcolormarker.TextSelectionData;

public class TextColorMarkerField
extends AbstractField<TextColorMarkerFieldValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextColorMarkerField.class);
    static final TextColorMarkerFieldValue EMPTY_VALUE = new TextColorMarkerFieldValue("", List.of());
    private List<TextColorMarkerDefinition> markerDefinitions = List.of();
    private boolean toolbarEnabled = true;
    private TextSelectionData currentSelection;
    private TextSelectionData lastSelection;
    public final Event<TextSelectionData> onTextSelected = new Event();

    public UiTextColorMarkerField createUiComponent() {
        UiTextColorMarkerField ui = new UiTextColorMarkerField();
        this.mapAbstractFieldAttributesToUiField((UiField)ui);
        ui.setToolbarEnabled(this.toolbarEnabled);
        ui.setMarkerDefinitions(TextColorMarkerField.createUiMarkerDefinitions(this.markerDefinitions));
        return ui;
    }

    private static List<UiTextColorMarkerFieldMarkerDefinition> createUiMarkerDefinitions(List<TextColorMarkerDefinition> markerDefinitions) {
        return markerDefinitions.stream().map(TextColorMarkerDefinition::toUiTextColorMarkerFieldMarkerDefinition).toList();
    }

    public List<TextColorMarkerDefinition> getMarkerDefinitions() {
        return this.markerDefinitions;
    }

    public void setMarkerDefinitions(List<TextColorMarkerDefinition> markerDefinitions, TextColorMarkerFieldValue value) {
        this.markerDefinitions = markerDefinitions == null ? List.of() : markerDefinitions;
        List<UiTextColorMarkerFieldMarkerDefinition> uiMarkerDefinitions = TextColorMarkerField.createUiMarkerDefinitions(this.markerDefinitions);
        UiTextColorMarkerFieldValue uiValue = value != null ? value.toUiTextColorMarkerFieldValue() : null;
        this.queueCommandIfRendered(() -> new UiTextColorMarkerField.SetMarkerDefinitionsCommand(this.getId(), uiMarkerDefinitions, uiValue));
        this.setValue(value);
    }

    public void setMarkerDefinitions(List<TextColorMarkerDefinition> markerDefinitions) {
        this.setMarkerDefinitions(markerDefinitions, EMPTY_VALUE);
    }

    public void setMarker(int markerDefinitionId, int start, int end) {
        TextColorMarker marker = new TextColorMarker(markerDefinitionId, start, end);
        this.validateMarker(marker);
        TextColorMarkerFieldValue val = new TextColorMarkerFieldValue(((TextColorMarkerFieldValue)this.getValue()).text(), new ArrayList<TextColorMarker>(((TextColorMarkerFieldValue)this.getValue()).markers()));
        val.markers().removeIf(m -> m.markerDefinitionId() == markerDefinitionId);
        val.markers().add(marker);
        val.markers().sort(Comparator.comparingInt(TextColorMarker::markerDefinitionId));
        this.setValue(val);
    }

    private TextSelectionData setCurrentSelection(TextSelectionData selection) {
        this.lastSelection = this.currentSelection;
        this.currentSelection = selection;
        return this.currentSelection;
    }

    public TextSelectionData getCurrentSelection() {
        return this.currentSelection;
    }

    public TextSelectionData getLastSelection() {
        return this.lastSelection;
    }

    public boolean isToolbarEnabled() {
        return this.toolbarEnabled;
    }

    public void setToolbarEnabled(boolean toolbarEnabled) {
        this.toolbarEnabled = toolbarEnabled;
        this.queueCommandIfRendered(() -> new UiTextColorMarkerField.SetToolbarEnabledCommand(this.getId(), toolbarEnabled));
    }

    @Override
    public void setValue(TextColorMarkerFieldValue value) {
        this.validateMarkers(value);
        super.setValue(value);
    }

    private void validateMarkers(TextColorMarkerFieldValue value) {
        if (value != null && value.markers() != null) {
            value.markers().forEach(this::validateMarker);
        }
    }

    private void validateMarker(TextColorMarker marker) {
        if (marker == null) {
            throw new IllegalTextColorMarkerException("Marker must not be null");
        }
        if (this.markerDefinitions.stream().noneMatch(def -> def.id() == marker.markerDefinitionId())) {
            throw new IllegalTextColorMarkerException("Marker definition ID must exist: " + marker.markerDefinitionId());
        }
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TEXT_COLOR_MARKER_FIELD_TEXT_SELECTED: {
                UiTextColorMarkerField.TextSelectedEvent textSelectedEvent = (UiTextColorMarkerField.TextSelectedEvent)event;
                if (textSelectedEvent.getEnd() == 0) {
                    this.setCurrentSelection(null);
                    break;
                }
                if (this.getEditingMode() == FieldEditingMode.DISABLED) break;
                this.onTextSelected.fire(this.setCurrentSelection(new TextSelectionData(textSelectedEvent.getStart(), textSelectedEvent.getEnd())));
                break;
            }
            case UI_FIELD_VALUE_CHANGED: {
                if (this.getEditingMode() != FieldEditingMode.DISABLED) {
                    this.applyValueFromUi(((UiField.ValueChangedEvent)event).getValue());
                    this.validate();
                    break;
                }
                LOGGER.warn("Got valueChanged event from disabled field {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getDebuggingId());
                break;
            }
            default: {
                super.handleUiEvent(event);
            }
        }
    }

    @Override
    public TextColorMarkerFieldValue convertUiValueToUxValue(Object value) {
        return value == null ? null : new TextColorMarkerFieldValue(((UiTextColorMarkerFieldValue)value).getText(), ((UiTextColorMarkerFieldValue)value).getMarkers().stream().map(m -> new TextColorMarker(m.getMarkerDefinitionId(), m.getStart(), m.getEnd())).toList());
    }

    @Override
    public Object convertUxValueToUiValue(TextColorMarkerFieldValue value) {
        return value == null ? null : value.toUiTextColorMarkerFieldValue();
    }
}

