/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiWorkSpaceLayoutView;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.panel.WindowButtonType;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.workspacelayout.SplitDirection;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutSplitPane;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.ViewDefinition;
import org.teamapps.ux.session.SessionContext;

public class WorkSpaceLayoutView {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLayout.class);
    public final Event<Boolean> onEffectiveVisibilityChanged = new Event();
    private boolean effectivelyVisible;
    private final WorkSpaceLayout workSpaceLayout;
    private final Event<Void> onRemoved = new Event();
    private final String id = UUID.randomUUID().toString();
    private final Panel panel;
    private WorkSpaceLayoutViewGroup viewGroup;
    private final boolean lazyLoading;
    private boolean closeable;
    private String tabTitle;
    private boolean visible = true;

    public WorkSpaceLayoutView(WorkSpaceLayout workSpaceLayout, Icon icon, String title, Component component, boolean closeable, boolean lazyLoading) {
        this(workSpaceLayout, new Panel(icon, title, component), null, closeable, lazyLoading);
    }

    public WorkSpaceLayoutView(WorkSpaceLayout workSpaceLayout, Panel panel, String tabTitle, boolean closeable, boolean lazyLoading) {
        this.workSpaceLayout = workSpaceLayout;
        this.panel = panel;
        panel.setParent(workSpaceLayout);
        this.tabTitle = tabTitle;
        this.closeable = closeable;
        this.lazyLoading = lazyLoading;
    }

    public WorkSpaceLayoutView(WorkSpaceLayout workSpaceLayout, Icon icon, String title, Component component) {
        this(workSpaceLayout, icon, title, component, true, false);
    }

    public ViewDefinition createViewDefinition() {
        return new ViewDefinition(this.id, this.closeable, this.visible);
    }

    public void setRelativeWidth(float width) {
        this.setSize(width, false, true);
    }

    public void setAbsoluteWidth(int width) {
        this.setSize(width, false, false);
    }

    public void setRelativeHeight(float height) {
        this.setSize(height, true, true);
    }

    public void setAbsoluteHeight(int height) {
        this.setSize(height, true, false);
    }

    private void setSize(float size, boolean isHeight, boolean isRelative) {
        if (this.viewGroup != null) {
            WorkSpaceLayoutItem currentItem = this.viewGroup;
            for (WorkSpaceLayoutSplitPane splitPane = this.viewGroup.getParent(); splitPane != null; splitPane = splitPane.getParent()) {
                boolean isFirstChild = splitPane.getFirstChild() == currentItem;
                if (splitPane.getSplitDirection() == (isHeight ? SplitDirection.HORIZONTAL : SplitDirection.VERTICAL)) {
                    if (isRelative) {
                        splitPane.setSizing(SplitSizePolicy.RELATIVE, isFirstChild ? size : 1.0f - size);
                        break;
                    }
                    splitPane.setSizing(isFirstChild ? SplitSizePolicy.FIRST_FIXED : SplitSizePolicy.LAST_FIXED, size);
                    break;
                }
                currentItem = splitPane;
            }
        }
    }

    private SessionContext getSessionContext() {
        return this.workSpaceLayout.getSessionContext();
    }

    public UiWorkSpaceLayoutView createUiView() {
        String icon = this.getSessionContext().resolveIcon(this.panel.getIcon());
        String title = null;
        title = this.tabTitle != null ? this.tabTitle : this.panel.getTitle();
        UiClientObjectReference uiPanel = null;
        if (!this.lazyLoading) {
            uiPanel = this.panel.createUiReference();
        }
        UiWorkSpaceLayoutView view = new UiWorkSpaceLayoutView(this.getId(), icon, title, uiPanel);
        view.setTabCloseable(this.closeable);
        view.setLazyLoading(this.lazyLoading);
        view.setVisible(this.visible);
        return view;
    }

    public Component getComponent() {
        return this.panel.getContent();
    }

    public void setComponent(Component component) {
        this.panel.setContent(component);
    }

    public Icon getIcon() {
        return this.panel.getIcon();
    }

    public void setIcon(Icon icon) {
        this.panel.setIcon(icon);
    }

    public String getTabTitle() {
        return this.tabTitle != null ? this.tabTitle : this.panel.getTitle();
    }

    public String getPanelTitle() {
        return this.panel.getTitle();
    }

    public void setPanelTitle(String title) {
        this.panel.setTitle(title);
    }

    public Toolbar getToolbar() {
        return this.panel.getToolbar();
    }

    public void setToolbar(Toolbar toolbar) {
        this.panel.setToolbar(toolbar);
    }

    public WorkSpaceLayoutView setLeftHeaderField(AbstractField<?> field, Icon icon, int minWidth, int maxWidth) {
        this.panel.setLeftHeaderField(field, icon, minWidth, maxWidth);
        return this;
    }

    public AbstractField<?> getLeftHeaderField() {
        return this.panel.getLeftHeaderField();
    }

    public WorkSpaceLayoutView setRightHeaderField(AbstractField<?> field, Icon icon, int minWidth, int maxWidth) {
        this.panel.setRightHeaderField(field, icon, minWidth, maxWidth);
        return this;
    }

    public AbstractField<?> getRightHeaderField() {
        return this.panel.getRightHeaderField();
    }

    public Panel getPanel() {
        return this.panel;
    }

    String getId() {
        return this.id;
    }

    public void select() {
        if (this.viewGroup != null) {
            this.viewGroup.setSelectedView(this);
        }
    }

    public void remove() {
        if (this.viewGroup != null) {
            this.viewGroup.removeView(this);
        }
    }

    void fireOnRemoved() {
        this.onRemoved.fire(null);
    }

    public WorkSpaceLayoutViewGroup getViewGroup() {
        return this.viewGroup;
    }

    void setViewGroup(WorkSpaceLayoutViewGroup viewGroup) {
        this.viewGroup = viewGroup;
    }

    public boolean isSelected() {
        return this.viewGroup != null && this.viewGroup.getSelectedView() == this;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
        if (this.workSpaceLayout != null) {
            this.workSpaceLayout.handleViewAttributeChangedViaApi(this);
        }
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (this.workSpaceLayout != null) {
            this.workSpaceLayout.handleViewAttributeChangedViaApi(this);
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.workSpaceLayout.handleViewAttributeChangedViaApi(this);
    }

    void setEffectivelyVisible(boolean effectivelyVisible) {
        boolean wasEffectivelyVisible = this.effectivelyVisible;
        this.effectivelyVisible = effectivelyVisible;
        if (wasEffectivelyVisible != effectivelyVisible) {
            this.onEffectiveVisibilityChanged.fire(effectivelyVisible);
        }
    }

    public boolean isEffectivelyVisible() {
        return this.effectivelyVisible;
    }

    public void updateWindowButtons(boolean showButtons) {
        if (!showButtons) {
            this.panel.setWindowButtons(Collections.emptyList());
        } else {
            ArrayList<WindowButtonType> buttons = new ArrayList<WindowButtonType>();
            buttons.add(WindowButtonType.MINIMIZE);
            buttons.add(WindowButtonType.MAXIMIZE_RESTORE);
            if (this.closeable) {
                buttons.add(WindowButtonType.CLOSE);
            }
            this.panel.setWindowButtons(buttons);
        }
    }
}

