/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.common;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiTreeGraphNodeImage;
import org.teamapps.util.UiUtil;

public class GraphNodeImage {
    private String url;
    private int width;
    private int height;
    private int centerTopDistance;
    private int centerLeftDistance;
    private CornerShape cornerShape = CornerShape.ROUNDED;
    private boolean shadow = false;
    private float borderWidth = 0.0f;
    private Color borderColor = new Color(100, 100, 100);

    public GraphNodeImage(String url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    public UiTreeGraphNodeImage createUiTreeGraphNodeImage() {
        UiTreeGraphNodeImage ui = new UiTreeGraphNodeImage(this.url, this.width, this.height);
        ui.setCenterTopDistance(this.centerTopDistance);
        ui.setCenterLeftDistance(this.centerLeftDistance);
        ui.setCornerShape(this.cornerShape.toUiCornerShape());
        ui.setShadow(this.shadow);
        ui.setBorderWidth(this.borderWidth);
        ui.setBorderColor(UiUtil.createUiColor(this.borderColor));
        return ui;
    }

    public String getUrl() {
        return this.url;
    }

    public GraphNodeImage setUrl(String url) {
        this.url = url;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public GraphNodeImage setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public GraphNodeImage setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getCenterTopDistance() {
        return this.centerTopDistance;
    }

    public GraphNodeImage setCenterTopDistance(int centerTopDistance) {
        this.centerTopDistance = centerTopDistance;
        return this;
    }

    public int getCenterLeftDistance() {
        return this.centerLeftDistance;
    }

    public GraphNodeImage setCenterLeftDistance(int centerLeftDistance) {
        this.centerLeftDistance = centerLeftDistance;
        return this;
    }

    public CornerShape getCornerShape() {
        return this.cornerShape;
    }

    public GraphNodeImage setCornerShape(CornerShape cornerShape) {
        this.cornerShape = cornerShape;
        return this;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public GraphNodeImage setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public GraphNodeImage setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public GraphNodeImage setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public static enum CornerShape {
        ORIGINAL,
        ROUNDED,
        CIRCLE;


        public UiTreeGraphNodeImage.CornerShape toUiCornerShape() {
            return UiTreeGraphNodeImage.CornerShape.valueOf((String)this.name());
        }
    }
}

