/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.pageview;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.teamapps.dto.UiPageViewBlock;
import org.teamapps.ux.component.pageview.PageViewBlockAlignment;
import org.teamapps.ux.component.toolbutton.ToolButton;

public abstract class AbstractPageViewBlock {
    private final String clientId = UUID.randomUUID().toString();
    private PageViewBlockAlignment alignment = PageViewBlockAlignment.FULL;
    private List<ToolButton> toolButtons = new ArrayList<ToolButton>();

    public AbstractPageViewBlock() {
    }

    public AbstractPageViewBlock(PageViewBlockAlignment alignment) {
        this.alignment = alignment;
    }

    public abstract UiPageViewBlock createUiBlock();

    protected void mapAbstractPageViewBlockAttributes(UiPageViewBlock uiBlock) {
        uiBlock.setId(this.clientId);
        uiBlock.setAlignment(this.alignment.toUiAlignment());
        uiBlock.setToolButtons(this.toolButtons.stream().map(button -> button.createUiComponentReference()).collect(Collectors.toList()));
    }

    String getClientId() {
        return this.clientId;
    }

    public PageViewBlockAlignment getAlignment() {
        return this.alignment;
    }

    public AbstractPageViewBlock setAlignment(PageViewBlockAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public List<ToolButton> getToolButtons() {
        return this.toolButtons;
    }

    public AbstractPageViewBlock setToolButtons(List<ToolButton> toolButtons) {
        this.toolButtons = toolButtons;
        return this;
    }
}

