/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public interface Resource {
    public InputStream getInputStream();

    default public long getLength() {
        try {
            int len;
            InputStream inputStream = this.getInputStream();
            byte[] buf = new byte[4096];
            int totalLength = 0;
            while ((len = inputStream.read(buf)) != -1) {
                totalLength += len;
            }
            return totalLength;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    default public String getName() {
        return null;
    }

    default public Date getLastModified() {
        return new Date();
    }

    default public Date getExpires() {
        return new Date(System.currentTimeMillis() + 604800000L);
    }

    default public String getMimeType() {
        return null;
    }

    default public boolean isAttachment() {
        return false;
    }
}

